% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{loo.glmmfields}
\alias{loo.glmmfields}
\alias{loo}
\title{Return LOO information criteria}
\usage{
\method{loo}{glmmfields}(x, ...)
}
\arguments{
\item{x}{Output from \code{\link[=glmmfields]{glmmfields()}}.
Must be fit with \code{save_log_lik = TRUE}, which is \emph{not} the default.}

\item{...}{Arguments for \code{\link[loo:relative_eff]{loo::relative_eff()}} and \code{\link[loo:loo]{loo::loo.array()}}.}
}
\description{
Extract the LOOIC (leave-one-out information criterion) using
\code{\link[loo:loo]{loo::loo()}}.
}
\examples{
\donttest{
set.seed(1)
s <- sim_glmmfields(n_draws = 12, n_knots = 12, gp_theta = 1.5,
gp_sigma = 0.2, sd_obs = 0.2)
# options(mc.cores = parallel::detectCores()) # for parallel processing

# save_log_lik defaults to FALSE to save space but is needed for loo():
m <- glmmfields(y ~ 0, time = "time",
 lat = "lat", lon = "lon", data = s$dat,
 nknots = 12, iter = 1000, chains = 4, seed = 1,
 save_log_lik = TRUE)
loo(m)
}
}
