% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reinstalling}
\alias{reinstalling}
\title{Reinstalling binary dependencies}
\description{
The \code{glmmTMB} package depends on several upstream packages, which it
uses in a way that depends heavily on their internal (binary) structure.
Sometimes, therefore, installing an update to one of these packages will
require that you re-install a \emph{binary-compatible} version of \code{glmmTMB},
i.e. a version that has been compiled with the updated version of the upstream
package.
\itemize{
\item If you have development tools (compilers etc.) installed, you
should be able to re-install a binary-compatible version of the package by running
\code{install.packages("glmmTMB", type="source")}. If you want to install
the development version of \code{glmmTMB} instead, you can use
\code{remotes::install_github("glmmTMB/glmmTMB/glmmTMB")}.
(On Windows, you can install development tools following the instructions at
\url{https://cran.r-project.org/bin/windows/Rtools/}; on MacOS, see
\url{https://mac.r-project.org/tools/}.)

\item If you do \emph{not} have development tools and can't/don't want to
install them (and so can't install packages with compiled code from source),
you have two choices:
\itemize{
\item revert the upstream package(s) to their previous binary version. For example, using the
\code{checkpoint} package:
\preformatted{
## load (installing if necessary) the checkpoint package
while (!require("checkpoint")) install.packages("checkpoint")
## retrieve build date of installed version of glmmTMB
bd <- as.character(asDateBuilt(
      packageDescription("glmmTMB",fields="Built")))
oldrepo <- getOption("repos")
use_mran_snapshot(bd) ## was setSnapshot() pre-checkpoint v1.0.0
install.packages("TMB")
options(repos=oldrepo) ## restore original repo
}
A similar recipe (substituting \code{Matrix} for \code{TMB} and \code{TMB} for \code{glmmTMB})
can be used if you get warnings about an incompatibility between \code{TMB} and \code{Matrix}.
\item hope that the glmmTMB maintainers have posted a binary
version of the package that works with your system; try installing it via
\code{install.packages("glmmTMB",repos="https://glmmTMB.github.io/glmmTMB/repos",type="binary")}
If this doesn't work, please file an issue (with full details about your
operating system and R version) asking the maintainers to build and
post an appropriate binary version of the package.
}
}
}
