% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.r
\docType{data}
\name{gss}
\alias{gss}
\title{General Social Study 2018}
\format{A data frame with 2044 observations on 9 variables.
\describe{
\item{\code{ABDEFECT}}{If there is a strong chance of serious defect in the baby?}
\item{\code{ABNOMORE}}{If she is married and does not want any more children?}
\item{\code{ABHLTH}}{If the womans own health is seriously endangered by the pregnancy?}
\item{\code{ABPOOR}}{If the family has a very low income and cannot afford any more children?}
\item{\code{ABRAPE}}{If she became pregnant as a result of rape?}
\item{\code{ABSINGLE}}{If she is not married and does not want to marry the man?}
\item{\code{AGE}}{Respondent's age}
\item{\code{SEX}}{Respondent's sex}
\item{\code{REGION}}{Region of interview}
\item{\code{DEGREE}}{Respondent's degree}
}}
\source{
\url{http://gss.norc.org}
}
\description{
This dataset includes 6 manifest items about abortion and several covariates from 2044 respondents to the 2018 General Social Survey. Respondents answer the questions whether or not think it should be possible for a pregnant woman to obtain a legal abortion. The covariates include age, sex, region, and degree of respondents.
}
\examples{
data("gss")
# Model 1: LCA
lca = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE, ABNOMORE) ~ 1,
           data = gss, nclass = 3)
summary(lca)

# Model 2: LCA with a covariate
lcr = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE, ABNOMORE) ~ SEX,
           data = gss, nclass = 3)
summary(lcr)
coef(lcr)

# Model 3: MGLCA
mglca = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE, ABNOMORE) ~ 1,
             group = REGION, data = gss, nclass = 3)

# Model 4: MGLCA with covariates
summary(mglca)
mglcr = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE, ABNOMORE) ~ AGE,
             group = SEX, data = gss, nclass = 3)
summary(mglcr)
coef(mglcr)

# Model 5: MLCA
mlca =  glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE, ABNOMORE) ~ 1,
             group = REGION, data = gss, nclass = 3, ncluster = 2)
summary(mlca)
}
\references{
Smith, Tom W, Peter Marsden, Michael Hout, and Jibum Kim. General Social Surveys, 2010/Principal Investigator, Tom W. Smith; Co-Principal Investigator, Peter V. Marsden; Co-Principal Investigator, Michael Hout; Sponsored by National Science Foundation. -NORC ed.- Chicago: NORC at the University of Chicago
}
\keyword{datasets}
