% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/commit.r
\docType{methods}
\name{descendant_of}
\alias{descendant_of}
\alias{descendant_of,git_commit,git_commit-method}
\title{Descendant}
\usage{
descendant_of(commit, ancestor)

\S4method{descendant_of}{git_commit,git_commit}(commit, ancestor)
}
\arguments{
\item{commit}{a S4 class git_commit \code{object}.}

\item{ancestor}{a S4 class git_commit \code{object} to check if
ancestor to \code{commit}.}
}
\value{
TRUE if commit is descendant of \code{ancestor}, else
FALSE
}
\description{
Determine if a commit is the descendant of another commit
}
\examples{
\dontrun{
## Create a directory in tempdir
path <- tempfile(pattern="git2r-")
dir.create(path)

## Initialize a repository
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           con = file.path(path, "test.txt"))
add(repo, "test.txt")
commit_1 <- commit(repo, "Commit message 1")

# Change file and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
             con = file.path(path, "test.txt"))
add(repo, "test.txt")
commit_2 <- commit(repo, "Commit message 2")

descendant_of(commit_1, commit_2)
descendant_of(commit_2, commit_1)
}
}
\keyword{methods}

