% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rearrangeFiles.R
\name{rearrangeFiles}
\alias{rearrangeFiles}
\title{Rearrange GIMMS NDVI3g.v0 Files}
\usage{
rearrangeFiles(x, dsn = getwd(), pattern = "^geo.*.VI3g$", pos = c(4, 6,
  11), ...)
}
\arguments{
\item{x}{\code{character}. Vector of local filepaths. If missing, 'dsn' will
be searched for available files via pattern matching.}

\item{dsn}{\code{character}, defaults to the current working directory. Path
to look for GIMMS-related data if 'x' is missing.}

\item{pattern}{\code{character}, defaults to \code{"^geo.*.VI3g$"} for
standard NDVI3g.v0 files. A regular expression passed to \code{\link{list.files}}.}

\item{pos}{\code{integer}, defaults to \code{c(4, 6, 11)} for standard
NDVI3g.v0 files. The start positions of year, month and part of the month
('a' or 'b') in the target GIMMS files.}

\item{...}{Further arguments passed to \code{\link{list.files}}.}
}
\value{
A \code{character} vector of filepaths arranged in ascending order of time.
}
\description{
Rearrange local GIMMS NDVI3g.v0 files in ascending order of time. Since the
naming convention has significantly changed towards NDVI3g.v1, such a measure
should only be relevant for older file formats.
}
\seealso{
\code{\link{list.files}}
}
