% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/createHeader.R
\name{createHeader}
\alias{createHeader}
\title{Create ENVI header file}
\usage{
createHeader(file, header)
}
\arguments{
\item{file}{Character. Absolute input filepath of the GIMMS binary file being
processed.}

\item{header}{Character. If not supplied, defaults to the default content of the
companion header file for GIMMS NDVI3g binary data. See seection 'Examples'
below for required file contents.}
}
\value{
A filename with the absolute location of the header file.
}
\description{
Create an ENVI header file (see \url{http://www.exelisvis.com/docs/ENVIHeaderFiles.html})
to properly import GIMMS binary data into native 'Raster*' format.
}
\examples{
\dontrun{
# Create standard GIMMS NDVI3g header file
gimms_header <- createHeader("~/geo13jul15a.n19-VI3g")
gimms_header
}
}
\author{
Florian Detsch
}

