% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{gof.test}
\alias{gof.test}
\title{Perform a goodness-of-fit test}
\usage{
gof.test(
  model,
  Beta = TRUE,
  nempirical = NULL,
  parallel = NULL,
  returnBeta = FALSE,
  seed = NULL
)
}
\arguments{
\item{model}{ghype model to test}

\item{Beta}{boolean, whether to use empirical Beta distribution approximation. Default TRUE}

\item{nempirical}{optional scalar, number of replicates for empirical beta distribution.}

\item{parallel}{optional, number of cores to use or boolean for parallel computation.
If passed TRUE uses all cores-1, else uses the number of cores passed. If none passed
performed not in parallel.}

\item{returnBeta}{boolean, return estimated parameters of Beta distribution? Default FALSE.}

\item{seed}{scalar, seed for the empirical distribution.}
}
\value{
p-value of test. If returnBeta=TRUE returns the p-value together with the parameters
 of the beta distribution.
}
\description{
Perform a goodness-of-fit test
}
\examples{
data("adj_karate")
confmodel <- scm(graph = adj_karate, directed = FALSE, selfloops = FALSE)
gof.test(model = confmodel, seed = 123)

}
