% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghype.R, R/igraphintegration.R, R/print.R
\name{ghype}
\alias{ghype}
\alias{ghype.matrix}
\alias{ghype.default}
\alias{ghype.igraph}
\alias{print.ghype}
\title{Fitting gHypEG models}
\usage{
ghype(
  graph,
  directed,
  selfloops,
  xi = NULL,
  omega = NULL,
  unbiased = FALSE,
  regular = FALSE,
  ...
)

\method{ghype}{matrix}(
  graph,
  directed,
  selfloops,
  xi = NULL,
  omega = NULL,
  unbiased = FALSE,
  regular = FALSE,
  ...
)

\method{ghype}{default}(
  graph,
  directed,
  selfloops,
  xi = NULL,
  omega = NULL,
  unbiased = FALSE,
  regular = FALSE,
  ...
)

\method{ghype}{igraph}(
  graph,
  directed,
  selfloops,
  xi = NULL,
  omega = NULL,
  unbiased = FALSE,
  regular = FALSE,
  ...
)

\method{print}{ghype}(x, suppressCall = FALSE, ...)
}
\arguments{
\item{graph}{either an adjacency matrix or an igraph graph.}

\item{directed}{a boolean argument specifying whether graph is directed or not.}

\item{selfloops}{a boolean argument specifying whether the model should incorporate selfloops.}

\item{xi}{an optional matrix defining the combinatorial matrix of the model.}

\item{omega}{an optional matrix defining the propensity matrix of the model.}

\item{unbiased}{a boolean argument specifying whether to model the hypergeometric ensemble (no propensity), defaults to FALSE.}

\item{regular}{a boolean argument specifying whether to model the 'gnp' ensemble (no xi), defaults to FALSE.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{ghype model}

\item{suppressCall}{boolean, suppress print of the call}
}
\value{
ghype return an object of class "ghype".
}
\description{
ghype is used to fit gHypEG models when the propensity matrix is known.
It can be used to estimate a null model (soft configuration model), or
the benchmark 'full-model', where the propensity matrix is fitted such
that the expected graph from the fitted model is the one passed to the
function.
}
\section{Methods (by class)}{
\itemize{
\item \code{matrix}: Fitting ghype models from an adjacency matrix

\item \code{default}: Generating a ghype model from given xi and omega

\item \code{igraph}: Fitting ghype models from an igraph graph

\item \code{ghype}: Print method for ghype object.
}}

\examples{
data("adj_karate")
fullmodel <- ghype(graph = adj_karate, directed = FALSE, selfloops = FALSE, unbiased = FALSE)

data('adj_karate')
model <- scm(adj_karate, FALSE, FALSE)
print(model)

}
