% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr.R, R/pr_create.R
\name{pr}
\alias{pr}
\alias{pr_create}
\title{GitHub Pull Request related tools}
\usage{
pr_create(repo, title, head, base, body = "", draft = FALSE)
}
\arguments{
\item{repo}{Character. Address of one or more repositories in "owner/name" format.}

\item{title}{Character. Title of the pull request.}

\item{head}{Character. The name of the branch where your changes are implemented.
For cross-repository pull requests in the same network, namespace \code{head} with a user
like this: \code{username:branch}.}

\item{base}{Character. The name of the branch you want the changes pulled into.
This should be an existing branch on the current repository. You cannot submit
a pull request to one repository that requests a merge to a base of another repository.}

\item{body}{Character. The text contents of the pull request.}

\item{draft}{Logical. Should the pull request be created as a draft pull request
(these cannot be merged until allowed by the author).}
}
\value{
\code{pr_create()} invisibly return a list containing the results of the relevant GitHub API calls.
}
\description{
\itemize{
\item \code{pr_create()} - create a pull request GitHub from the \code{base} branch to the \code{head} branch.
}
}
\examples{
\dontrun{
repo_create("ghclass-test", "test_pr", auto_init=TRUE)

branch_create("ghclass-test/test_pr", branch = "main", new_branch = "test")

repo_modify_file("ghclass-test/test_pr", "README.md", pattern = "test_pr",
                 content = "Hello", method = "after", branch = "test")

pr_create("ghclass-test/test_pr", title = "merge", head = "test", base = "main")

repo_delete("ghclass-test/test_pr", prompt = FALSE)
}
}
\seealso{
\link{repo_issues}
}
