% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{theme_clean}
\alias{theme_clean}
\title{Clean ggplot theme}
\usage{
theme_clean(base_size = 12, base_family = "sans")
}
\arguments{
\item{base_size}{Base font size.}

\item{base_family}{Base font family.}
}
\description{
Clean ggplot theme with no panel background, black axis lines
  and grey fill colour for chart elements.
}
\examples{
library("ggplot2")
p <- ggplot(mtcars, aes(x = wt, y = mpg, colour = factor(gear))) +
  geom_point() +
  facet_wrap(~am) +
  geom_smooth(method = "lm", se = FALSE) +
  theme_clean()
p
}
\seealso{
Other themes: \code{\link{theme_base}},
  \code{\link{theme_foundation}},
  \code{\link{theme_igray}}, \code{\link{theme_par}},
  \code{\link{theme_solid}}
}
\author{
Konrad Zdeb \email{name.surname@me.com}
}
\concept{themes}
