% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geom-interpolate-tern.R
\name{geom_interpolate_tern}
\alias{GeomInterpolateTern}
\alias{InterpolateTern}
\alias{geom_interpolate_tern}
\alias{geom_interpolation}
\title{Ternary Interpolation}
\usage{
geom_interpolate_tern(mapping = NULL, data = NULL,
  stat = "InterpolateTern", position = "identity", lineend = "butt",
  linejoin = "round", linemitre = 1, na.rm = FALSE,
  n = getOption("tern.mesh.size"), buffer = getOption("tern.mesh.buffer"),
  ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this
layer.}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{lineend}{Line end style (round, butt, square)}

\item{linejoin}{Line join style (round, mitre, bevel)}

\item{linemitre}{Line mitre limit (number greater than 1)}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{n}{Number of grid points in each direction of the mesh. Can be scalar or a length-2 integer vector.}

\item{buffer}{factor to buffer the mesh, to prevent ugly truncation of contours, 1.0 means no buffering}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\description{
This is the heavily requested geometry for interpolating between ternary values, results being
rendered using contours on a ternary mesh.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "InterpolateTern")}
}
\examples{
data(Feldspar)
ggtern(Feldspar,aes(x=Or,y=An,z=Ab)) +
geom_interpolate_tern(aes(value=P.Gpa,color=..level..),binwidth=20) +
geom_point()
}
\seealso{
\code{\link{stat_interpolate_tern}}
}

