% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfit2_p.R
\name{survfit2_p}
\alias{survfit2_p}
\title{Calculate p-value}
\usage{
survfit2_p(x, pvalue_fun = format_p, prepend_p = TRUE, rho = 0)
}
\arguments{
\item{x}{a 'survfit2' object}

\item{pvalue_fun}{function to round and style p-value with}

\item{prepend_p}{prepend \code{"p="} to formatted p-value}

\item{rho}{argument passed to  \code{survival::survdiff(rho=)}}
}
\value{
a string
}
\description{
The function \code{survfit2_p()} wraps \code{survival::survdiff()} and returns
a formatted p-value.
}
\examples{
sf <- survfit2(Surv(time, status) ~ sex, data = df_lung)

sf \%>\%
  ggsurvfit() +
  add_confidence_interval() +
  add_risktable() +
  labs(caption = glue::glue("Log-rank {survfit2_p(sf)}"))

sf \%>\%
  ggsurvfit() +
  add_confidence_interval() +
  add_risktable() +
  annotate("text", x = 2, y = 0.05, label = glue::glue("{survfit2_p(sf)}"))
}
