% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcuminc.R
\name{ggcuminc}
\alias{ggcuminc}
\title{Plot Cumulative Incidence}
\usage{
ggcuminc(
  x,
  outcome = NULL,
  linetype_aes = FALSE,
  theme = theme_ggsurvfit_default(),
  ...
)
}
\arguments{
\item{x}{a 'survfit' object created with \code{survfit2()}}

\item{outcome}{string indicating which outcome(s) to include in plot.
Default is to include the first competing event.}

\item{linetype_aes}{logical indicating whether to add \code{ggplot2::aes(linetype = strata)}
to the \code{ggplot2::geom_step()} call. When strata are present, the resulting figure
will be a mix a various line types for each stratum.}

\item{theme}{a survfit theme. Default is \code{theme_ggsurvfit_default()}}

\item{...}{arguments passed to \code{ggplot2::geom_step(...)}, e.g. \code{size = 2}}
}
\value{
a ggplot2 figure
}
\description{
Plot a cumulative incidence object created with \code{tidycmprsk::cuminc()}.
}
\examples{
library(tidycmprsk)

cuminc(Surv(ttdeath, death_cr) ~ trt, trial) \%>\%
  ggcuminc(outcome = "death from cancer") +
  add_confidence_interval() +
  add_risktable()

cuminc(Surv(ttdeath, death_cr) ~ trt, trial) \%>\%
  ggcuminc(outcome = c("death from cancer", "death other causes")) +
  add_risktable()
}
