% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcoefstats.R
\name{ggcoefstats}
\alias{ggcoefstats}
\title{Dot-and-whisker plots for regression analyses}
\usage{
ggcoefstats(
  x,
  output = "plot",
  statistic = NULL,
  conf.int = TRUE,
  conf.level = 0.95,
  k = 2L,
  exclude.intercept = FALSE,
  effsize = "eta",
  meta.analytic.effect = FALSE,
  meta.type = "parametric",
  bf.message = TRUE,
  sort = "none",
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  only.significant = FALSE,
  point.args = list(size = 3, color = "blue"),
  errorbar.args = list(height = 0),
  vline = TRUE,
  vline.args = list(size = 1, linetype = "dashed"),
  stats.labels = TRUE,
  stats.label.color = NULL,
  stats.label.args = list(size = 3, direction = "y", min.segment.length = 0),
  package = "RColorBrewer",
  palette = "Dark2",
  ggtheme = ggstatsplot::theme_ggstatsplot(),
  ...
)
}
\arguments{
\item{x}{A model object to be tidied, or a tidy data frame containing results
from a regression model. Function internally uses
\code{parameters::model_parameters()} to get a tidy dataframe. If a dataframe is
entered, it \emph{must} contain at the minimum two columns named \code{term} (names
of predictors) and \code{estimate} (corresponding estimates of coefficients or
other quantities of interest).}

\item{output}{Character describing the expected output from this function:
\code{"plot"} (visualization of regression coefficients) or \code{"tidy"} (tidy
dataframe of results \code{parameters::model_parameters}) or \code{"glance"} (object
from \code{performance::model_performance}).}

\item{statistic}{Which statistic is to be displayed (either \code{"t"} or \code{"f"}or
\code{"z"} or \code{"chi"}) in the label. This is relevant if the \code{x} argument is a
\emph{dataframe}.}

\item{conf.int}{Logical. Decides whether to display confidence intervals as
error bars (Default: \code{TRUE}).}

\item{conf.level}{Numeric deciding level of confidence or credible intervals
(Default: \code{0.95}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{exclude.intercept}{Logical that decides whether the intercept should be
excluded from the plot (Default: \code{FALSE}).}

\item{effsize}{Character describing the effect size to be displayed: \code{"eta"}
(default) or \code{"omega"}. This argument is relevant only for models objects
with \emph{F}-statistic.}

\item{meta.analytic.effect}{Logical that decides whether subtitle for
meta-analysis via linear (mixed-effects) models (default: \code{FALSE}). If
\code{TRUE}, input to argument \code{subtitle} will be ignored. This will be mostly
relevant if a data frame with estimates and their standard errors is
entered.}

\item{meta.type}{Type of statistics used to carry out random-effects
meta-analysis. If \code{"parametric"} (default), \code{metafor::rma} function will be
used. If \code{"robust"}, \code{metaplus::metaplus} function will be used. If
\code{"bayes"}, \code{metaBMA::meta_random} function will be used.}

\item{bf.message}{Logical that decides whether results from running a
Bayesian meta-analysis assuming that the effect size \emph{d} varies across
studies with standard deviation \emph{t} (i.e., a random-effects analysis)
should be displayed in caption. Defaults to \code{TRUE}.}

\item{sort}{If \code{"none"} (default) do not sort, \code{"ascending"} sort by
increasing coefficient value, or \code{"descending"} sort by decreasing
coefficient value.}

\item{xlab}{Label for \code{x} axis variable. If \code{NULL} (default),
variable name for \code{x} will be used.}

\item{ylab}{Labels for \code{y} axis variable. If \code{NULL} (default),
variable name for \code{y} will be used.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle. The input to this argument
will be ignored if \code{meta.analytic.effect} is set to \code{TRUE}.}

\item{caption}{The text for the plot caption. This argument is relevant only
if \code{bf.message = FALSE}.}

\item{only.significant}{If \code{TRUE}, only stats labels for significant effects
is shown (Default: \code{FALSE}). This can be helpful when a large number of
regression coefficients are to be displayed in a single plot. Relevant only
when the \code{output} is a plot.}

\item{point.args}{Additional arguments that will be passed to
\code{geom_point} geom. Please see documentation for that function to
know more about these arguments.}

\item{errorbar.args}{Additional arguments that will be passed to
\code{geom_errorbarh} geom. Please see documentation for that function
to know more about these arguments.}

\item{vline}{Decides whether to display a vertical line (Default: \code{"TRUE"}).}

\item{vline.args}{Additional arguments that will be passed to
\code{geom_vline} geom. Please see documentation for that function to
know more about these arguments.}

\item{stats.labels}{Logical. Decides whether the statistic and \emph{p}-values for
each coefficient are to be attached to each dot as a text label using
\code{ggrepel} (Default: \code{TRUE}).}

\item{stats.label.color}{Color for the labels. If set to \code{NULL}, colors will
be chosen from the specified \code{package} (Default: \code{"RColorBrewer"}) and
\code{palette} (Default: \code{"Dark2"}).}

\item{stats.label.args}{Additional arguments that will be passed to
\code{ggrepel::geom_label_repel} geom. Please see documentation for that
function to know more about these arguments.}

\item{package, palette}{Name of the package from which the given palette is to
be extracted. The available palettes and packages can be checked by running
\code{View(paletteer::palettes_d_names)}.}

\item{ggtheme}{A \code{{ggplot2}} theme. Default value is
\code{ggstatsplot::theme_ggstatsplot()}. Any of the \code{{ggplot2}} themes (e.g.,
\code{theme_bw()}), or themes from extension packages are allowed (e.g.,
\code{ggthemes::theme_fivethirtyeight()}, \code{hrbrthemes::theme_ipsum_ps()}, etc.).
But note that sometimes these themes will remove some of the details that
\code{{ggstatsplot}} plots typically contains. For example, if relevant,
\code{ggbetweenstats()} shows details about multiple comparison test as a label
on the secondary Y-axis. Some themes (e.g.
\code{ggthemes::theme_fivethirtyeight()}) will remove the secondary Y-axis and
thus the details as well.}

\item{...}{Additional arguments to tidying method. For more, see
\code{parameters::model_parameters}.}
}
\description{
Plot with the regression coefficients' point estimates as dots with
confidence interval whiskers and other statistical details included as
labels.
}
\details{
For details, see:
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggcoefstats.html}
}
\note{
\enumerate{
\item In case you want to carry out meta-analysis, you will be asked to install
the needed packages (\code{{metafor}}, \code{{metaplus}}, or \code{{metaBMA}}) for
meta-analysis (if unavailable).
\item All rows of regression estimates where either of the following
quantities is \code{NA} will be removed if labels are requested: \code{estimate},
\code{statistic}, \code{p.value}.
\item Given the rapid pace at which new methods are added to these packages, it
is recommended that you install the GitHub versions of \code{{parameters}} and
\code{{performance}} in order to make most of this function.
}
}
\examples{
\donttest{
# for reproducibility
set.seed(123)
library(ggstatsplot)

# model object
mod <- lm(formula = mpg ~ cyl * am, data = mtcars)

# to get a plot
ggcoefstats(mod, output = "plot")

# to get a tidy dataframe
ggcoefstats(mod, output = "tidy")

# to get a glance summary
ggcoefstats(mod, output = "glance")
}
}
