% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggbetweenstats.R
\name{grouped_ggbetweenstats}
\alias{grouped_ggbetweenstats}
\title{Violin plots for group or condition comparisons in between-subjects
designs repeated across all levels of a grouping variable.}
\usage{
grouped_ggbetweenstats(
  data,
  x,
  y,
  grouping.var,
  outlier.label = NULL,
  title.prefix = NULL,
  output = "plot",
  ...,
  plotgrid.args = list(),
  title.text = NULL,
  title.args = list(size = 16, fontface = "bold"),
  caption.text = NULL,
  caption.args = list(size = 10),
  sub.text = NULL,
  sub.args = list(size = 12)
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}

\item{outlier.label}{Label to put on the outliers that have been tagged. This
\strong{can't} be the same as \code{x} argument.}

\item{title.prefix}{Character string specifying the prefix text for the fixed
plot title (name of each factor level) (Default: \code{NULL}). If \code{NULL}, the
variable name entered for \code{grouping.var} will be used.}

\item{output}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results. If
you have set \code{results.subtitle = FALSE}, then this will return a \code{NULL}.
Setting this to \code{"caption"} will return the expression containing details
about Bayes Factor analysis, but valid only when \code{type = "parametric"} and
\code{bf.message = TRUE}, otherwise this will return a \code{NULL}.}

\item{...}{
  Arguments passed on to \code{\link[=ggbetweenstats]{ggbetweenstats}}
  \describe{
    \item{\code{plot.type}}{Character describing the \emph{type} of plot. Currently supported
plots are \code{"box"} (for pure boxplots), \code{"violin"} (for pure violin plots),
and \code{"boxviolin"} (for a combination of box and violin plots; default).}
    \item{\code{xlab}}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}
    \item{\code{ylab}}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}
    \item{\code{pairwise.comparisons}}{Logical that decides whether pairwise comparisons
are to be displayed (default: \code{TRUE}). Please note that only
\strong{significant} comparisons will be shown by default. To change this
behavior, select appropriate option with \code{pairwise.display} argument. The
pairwise comparison dataframes are prepared using the
\code{pairwiseComparisons::pairwise_comparisons} function. For more details
about pairwise comparisons, see the documentation for that function.}
    \item{\code{p.adjust.method}}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}
    \item{\code{pairwise.display}}{Decides which pairwise comparisons to display.
Available options are \code{"significant"} (abbreviation accepted: \code{"s"}) or
\code{"non-significant"} (abbreviation accepted: \code{"ns"}) or
\code{"everything"}/\code{"all"}. The default is \code{"significant"}. You can use this
argument to make sure that your plot is not uber-cluttered when you have
multiple groups being compared and scores of pairwise comparisons being
displayed.}
    \item{\code{bf.prior}}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}
    \item{\code{bf.message}}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}
    \item{\code{results.subtitle}}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}
    \item{\code{subtitle}}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}
    \item{\code{caption}}{The text for the plot caption.}
    \item{\code{sample.size.label}}{Logical that decides whether sample size information
should be displayed for each level of the grouping variable \code{x} (Default:
\code{TRUE}).}
    \item{\code{notch}}{A logical. If \code{FALSE} (default), a standard box plot will be
displayed. If \code{TRUE}, a notched box plot will be used. Notches are used to
compare groups; if the notches of two boxes do not overlap, this suggests
that the medians are significantly different. In a notched box plot, the
notches extend \code{1.58 * IQR / sqrt(n)}, where IQR: Inter-Quartile Range.
This gives a roughly \verb{95\%} confidence interval for comparing medians.}
    \item{\code{notchwidth}}{For a notched box plot, width of the notch relative to the
body (default \code{0.5}).}
    \item{\code{outlier.color}}{Default aesthetics for outliers (Default: \code{"black"}).}
    \item{\code{outlier.tagging}}{Decides whether outliers should be tagged (Default:
\code{FALSE}).}
    \item{\code{outlier.shape}}{Hiding the outliers can be achieved by setting
\code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the \code{y}-axis will be
the same with outliers shown and outliers hidden.}
    \item{\code{outlier.label.args}}{A list of additional aesthetic arguments to be
passed to \code{ggrepel::geom_label_repel} for outlier label plotting.}
    \item{\code{outlier.coef}}{Coefficient for outlier detection using Tukey's method.
With Tukey's method, outliers are below (1st Quartile) or above (3rd
Quartile) \code{outlier.coef} times the Inter-Quartile Range (IQR) (Default:
\code{1.5}).}
    \item{\code{centrality.plotting}}{Logical that decides whether centrality tendency measure
is to be displayed as a point with a label (Default: \code{TRUE}). Function
decides which central tendency measure to show depending on the \code{type}
argument (\strong{mean} for parametric, \strong{median} for non-parametric,
\strong{trimmed mean} for robust, and \strong{MAP estimator} for Bayes).}
    \item{\code{point.args}}{A list of additional aesthetic arguments to be passed to
the \code{geom_point} displaying the raw data.}
    \item{\code{violin.args}}{A list of additional aesthetic arguments to be passed to
the \code{geom_violin}.}
    \item{\code{ggplot.component}}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{ggplot2} function or a list of \code{ggplot2} functions.}
    \item{\code{package}}{Name of the package from which the given palette is to
be extracted. The available palettes and packages can be checked by running
\code{View(paletteer::palettes_d_names)}.}
    \item{\code{palette}}{Name of the package from which the given palette is to
be extracted. The available palettes and packages can be checked by running
\code{View(paletteer::palettes_d_names)}.}
    \item{\code{centrality.point.args}}{A list of additional aesthetic
arguments to be passed to \code{ggplot2::geom_point} and
\code{ggrepel::geom_label_repel} geoms, which are involved in mean plotting.}
    \item{\code{centrality.label.args}}{A list of additional aesthetic
arguments to be passed to \code{ggplot2::geom_point} and
\code{ggrepel::geom_label_repel} geoms, which are involved in mean plotting.}
    \item{\code{ggsignif.args}}{A list of additional aesthetic
arguments to be passed to \code{ggsignif::geom_signif}.}
    \item{\code{ggtheme}}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}
    \item{\code{ggstatsplot.layer}}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}
    \item{\code{type}}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}
    \item{\code{effsize.type}}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"eta"} (partial eta-squared) or \code{"omega"} (partial
omega-squared).}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}
    \item{\code{var.equal}}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    (or Satterthwaite) approximation to the degrees of freedom is used.}
    \item{\code{conf.level}}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} confidence/credible intervals (\code{0.95}).}
    \item{\code{nboot}}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}
    \item{\code{tr}}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}
  }}

\item{plotgrid.args}{A list of additional arguments to \code{cowplot::plot_grid}.}

\item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}

\item{title.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}

\item{caption.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}

\item{sub.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("maturing")}

Helper function for \code{ggstatsplot::ggbetweenstats} to apply this function
across multiple levels of a given factor and combining the resulting plots
using \code{ggstatsplot::combine_plots2}.
}
\examples{
\donttest{
# to get reproducible results from bootstrapping
set.seed(123)

# the most basic function call
ggstatsplot::grouped_ggbetweenstats(
  data = dplyr::filter(ggplot2::mpg, drv != "4"),
  x = year,
  y = hwy,
  grouping.var = drv,
  conf.level = 0.99
)

# modifying individual plots using `ggplot.component` argument
ggstatsplot::grouped_ggbetweenstats(
  data = dplyr::filter(
    ggstatsplot::movies_long,
    genre \%in\% c("Action", "Comedy"),
    mpaa \%in\% c("R", "PG")
  ),
  x = genre,
  y = rating,
  grouping.var = mpaa,
  results.subtitle = FALSE,
  ggplot.component = ggplot2::scale_y_continuous(
    breaks = seq(1, 9, 1),
    limits = (c(1, 9))
  )
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggbetweenstats.html}
}
\seealso{
\code{\link{ggbetweenstats}}, \code{\link{ggwithinstats}},
\code{\link{grouped_ggwithinstats}}
}
