% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggdotplotstats.R
\name{grouped_ggdotplotstats}
\alias{grouped_ggdotplotstats}
\title{Grouped histograms for distribution of a labeled numeric variable}
\usage{
grouped_ggdotplotstats(
  data,
  x,
  y,
  grouping.var,
  title.prefix = NULL,
  output = "plot",
  ...,
  plotgrid.args = list(),
  title.text = NULL,
  title.args = list(size = 16, fontface = "bold"),
  caption.text = NULL,
  caption.args = list(size = 10),
  sub.text = NULL,
  sub.args = list(size = 12)
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{A numeric variable from the dataframe \code{data}.}

\item{y}{Label or grouping variable.}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}

\item{title.prefix}{Character string specifying the prefix text for the fixed
plot title (name of each factor level) (Default: \code{NULL}). If \code{NULL}, the
variable name entered for \code{grouping.var} will be used.}

\item{output}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results. If
you have set \code{results.subtitle = FALSE}, then this will return a \code{NULL}.
Setting this to \code{"caption"} will return the expression containing details
about Bayes Factor analysis, but valid only when \code{type = "parametric"} and
\code{bf.message = TRUE}, otherwise this will return a \code{NULL}. For functions
\code{ggpiestats} and \code{ggbarstats}, setting \code{output = "proptest"} will return a
dataframe containing results from proportion tests.}

\item{...}{
  Arguments passed on to \code{\link[=ggdotplotstats]{ggdotplotstats}}
  \describe{
    \item{\code{point.args}}{A list of additional aesthetic arguments passed to
\code{geom_point}.}
    \item{\code{test.value}}{A number specifying the value of the null hypothesis
(Default: \code{0}).}
    \item{\code{test.k}}{Integer denoting the number of decimal places expected for
\code{test.value} label. (Default: \code{0} ).}
    \item{\code{test.value.line}}{Logical that decides whether a line corresponding to
the \code{test.value} should be superimposed on the plot.}
    \item{\code{test.value.line.args}}{A list of additional
aesthetic arguments to be passed to the \code{geom_line} used to display the
lines corresponding to the centrality parameter and test value.}
    \item{\code{test.value.label.args}}{A list of additional
aesthetic arguments to be passed to the \code{geom_label} used to display the
label corresponding to the centrality parameter and test value.}
    \item{\code{centrality.parameter}}{Decides \emph{which} measure of central tendency
(\code{"mean"} or \code{"median"}) is to be displayed as a vertical line. To not show
any parameter, set this to \code{"none"}.}
    \item{\code{centrality.k}}{Integer denoting the number of decimal places expected
for centrality parameter label. (Default: \code{2}).}
    \item{\code{centrality.line.args}}{A list of additional
aesthetic arguments to be passed to the \code{geom_line} used to display the
lines corresponding to the centrality parameter and test value.}
    \item{\code{centrality.label.args}}{A list of additional
aesthetic arguments to be passed to the \code{geom_label} used to display the
label corresponding to the centrality parameter and test value.}
    \item{\code{xlab}}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}
    \item{\code{subtitle}}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}
    \item{\code{caption}}{The text for the plot caption.}
    \item{\code{type}}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}
    \item{\code{bf.prior}}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}
    \item{\code{bf.message}}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}
    \item{\code{effsize.type}}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"d"} (for Cohen's \emph{d}) or \code{"g"} (for Hedge's \emph{g}).}
    \item{\code{conf.level}}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}
    \item{\code{nboot}}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}
    \item{\code{results.subtitle}}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}
    \item{\code{ggplot.component}}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function.}
    \item{\code{ggtheme}}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}
    \item{\code{ggstatsplot.layer}}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}
    \item{\code{ylab}}{Labels for \code{x}- and \code{y}- axis variables, respectively
(Defaults: \code{"regression coefficient"} and \code{"term"}).}
  }}

\item{plotgrid.args}{A list of additional arguments to \code{cowplot::plot_grid}.}

\item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}

\item{title.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}

\item{caption.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}

\item{sub.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}
}
\description{
Helper function for \code{ggstatsplot::ggdotplotstats} to apply this
function across multiple levels of a given factor and combining the
resulting plots using \code{ggstatsplot::combine_plots}.
}
\examples{
\donttest{
# for reproducibility
set.seed(123)

# removing factor level with very few no. of observations
df <- dplyr::filter(.data = ggplot2::mpg, cyl \%in\% c("4", "6", "8"))

# plot
ggstatsplot::grouped_ggdotplotstats(
  data = df,
  x = "cty",
  y = "manufacturer",
  grouping.var = "cyl",
  test.value = 15.5,
  title.prefix = "cylinder count",
  ggplot.component = ggplot2::scale_x_continuous(
    sec.axis = ggplot2::dup_axis(),
    limits = c(12, 24),
    breaks = seq(12, 24, 2)
  ),
  messages = FALSE
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggdotplotstats.html}
}
\seealso{
\code{\link{grouped_gghistostats}}, \code{\link{ggdotplotstats}},
\code{\link{gghistostats}}
}
\author{
\href{https://github.com/IndrajeetPatil}{Indrajeet Patil}
}
