% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_anova_subtitles.R
\name{subtitle_anova_bayes}
\alias{subtitle_anova_bayes}
\title{Making text subtitle for the between-subject one-way anova designs.}
\usage{
subtitle_anova_bayes(data, x, y, effsize.type = "unbiased",
  partial = TRUE, var.equal = FALSE, bf.prior = 0.707,
  paired = FALSE, k = 2, ...)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{The grouping variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d} for \strong{t-test};
\code{"partial_eta"} for partial eta-squared for \strong{anova}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}; \code{"partial_omega"} for partial
omega-squared for \strong{anova})).}

\item{partial}{Logical that decides if partial eta-squared or omega-squared
are returned (Default: \code{TRUE}). If \code{FALSE}, eta-squared or omega-squared
will be returned. Valid only for objects of class \code{lm}, \code{aov}, \code{anova}, or
\code{aovlist}.}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{paired}{a logical indicating whether you want a paired
    t-test.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments (ignored).}
}
\description{
Making text subtitle for the between-subject one-way anova designs.
}
\examples{
\dontrun{
# with defaults
subtitle_anova_bayes(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  k = 2,
  bf.prior = 0.8
)

# modifying the defaults
subtitle_anova_bayes(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  effsize.type = "partial_eta",
  var.equal = TRUE
)
}
}
\author{
Indrajeet Patil
}
