% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcorrmat.R
\name{ggcorrmat}
\alias{ggcorrmat}
\title{Visualization of a correlalogram (or correlation matrix)}
\usage{
ggcorrmat(data, cor.vars = NULL, cor.vars.names = NULL,
  output = "plot", matrix.type = "full", method = "square",
  corr.method = "pearson", type = NULL, exact = FALSE,
  continuity = TRUE, beta = 0.1, digits = 2, k = NULL,
  sig.level = 0.05, p.adjust.method = "none", hc.order = FALSE,
  hc.method = "complete", lab = TRUE, package = "RColorBrewer",
  palette = "Dark2", direction = 1, colors = c("#E69F00", "white",
  "#009E73"), outline.color = "black", ggtheme = ggplot2::theme_bw(),
  ggstatsplot.layer = TRUE, title = NULL, subtitle = NULL,
  caption = NULL, caption.default = TRUE, lab.col = "black",
  lab.size = 5, insig = "pch", pch = 4, pch.col = "black",
  pch.cex = 11, tl.cex = 12, tl.col = "black", tl.srt = 45,
  axis.text.x.margin.l = 0, axis.text.x.margin.t = 0,
  axis.text.x.margin.r = 0, axis.text.x.margin.b = 0,
  messages = TRUE)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{cor.vars}{List of variables for which the correlation matrix is to be
computed and visualized. If \code{NULL} (default), all numeric variables from
\code{data} will be used.}

\item{cor.vars.names}{Optional list of names to be used for \code{cor.vars}. The
names should be entered in the same order.}

\item{output}{Character that decides expected output from this function:
\code{"plot"} (for visualization matrix) or \code{"correlations"} (or \code{"corr"} or
\code{"r"}; for correlation matrix) or \code{"p-values"} (or \code{"p.values"} or \code{"p"};
for a matrix of \emph{p}-values) or \code{"ci"} (for a tibble with confidence
intervals for unique correlation pairs; not available for robust
correlation) or \code{"n"} (or \code{"sample.size"} for a tibble with sample sizes
for each correlation pair).}

\item{matrix.type}{Character, \code{"full"} (default), \code{"upper"} or \code{"lower"},
display full matrix, lower triangular or upper triangular matrix.}

\item{method}{Character argument that decides the visualization method of
correlation matrix to be used. Allowed values are \code{"square"} (default),
\code{"circle"}}

\item{corr.method, type}{A character string indicating which correlation
coefficient is to be computed (\code{"pearson"} (default) or \code{"kendall"} or
\code{"spearman"}). \code{"robust"} can also be entered but only if \code{output} argument
is set to either \code{"correlations"} or \code{"p-values"}. The robust correlation
used is percentage bend correlation (see \code{?WRS2::pball}). Abbreviations
will also work: \code{"p"} (for parametric/Pearson's \emph{r}), \code{"np"}
(nonparametric/Spearman's \emph{rho}), \code{"r"} (robust).}

\item{exact}{A logical indicating whether an exact \emph{p}-value should be
computed. Used for Kendall's \emph{tau} and Spearman's \emph{rho}. For more details,
see \code{?stats::cor.test}.}

\item{continuity}{A logical. If \code{TRUE}, a continuity correction is used for
Kendall's \emph{tau} and Spearman's \emph{rho} when not computed exactly (Default:
\code{TRUE}).}

\item{beta}{A numeric bending constant for robust correlation coefficient
(Default: \code{0.1}).}

\item{digits, k}{Decides the number of decimal digits to be displayed
(Default: \code{2}).}

\item{sig.level}{Significance level (Default: \code{0.05}). If the \emph{p}-value in
\emph{p}-value matrix is bigger than \code{sig.level}, then the corresponding
correlation coefficient is regarded as insignificant and flagged as such in
the plot. This argument is relevant only when \code{output = "plot"}.}

\item{p.adjust.method}{What adjustment for multiple tests should be used?
(\code{"holm"}, \code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"},
\code{"fdr"}, \code{"none"}). See \code{stats::p.adjust} for details about why to use
\code{"holm"} rather than \code{"bonferroni"}). Default is \code{"none"}. If adjusted
\emph{p}-values are displayed in the visualization of correlation matrix, the
\strong{adjusted} \emph{p}-values will be used for the \strong{upper} triangle, while
\strong{unadjusted} \emph{p}-values will be used for the \strong{lower} triangle of the
matrix.}

\item{hc.order}{Logical value. If \code{TRUE}, correlation matrix will be
hc.ordered using \code{hclust} function (Default is \code{FALSE}).}

\item{hc.method}{The agglomeration method to be used in \code{hclust} (see
\code{?hclust}).}

\item{lab}{Logical value. If \code{TRUE}, correlation coefficient values will be
displayed in the plot.}

\item{package}{Name of package from which the palette is desired as string
or symbol.}

\item{palette}{Name of palette as string or symbol.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{colors}{A vector of 3 colors for low, mid, and high correlation values.
If set to \code{NULL}, manual specification of colors will be turned off and 3
colors from the specified \code{palette} from \code{package} will be selected.}

\item{outline.color}{The outline color of square or circle. Default value is
\code{"gray"}.}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_economist()},
\code{hrbrthemes::theme_ipsum_ps()}, \code{ggthemes::theme_fivethirtyeight()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}).}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle.}

\item{caption}{The text for the plot caption. If not specified (if it is
\code{NULL}, i.e.), a default caption will be shown.}

\item{caption.default}{Logical decides whether the default caption should be
shown.}

\item{lab.col}{Color to be used for the correlation coefficient labels
(applicable only when \code{lab = TRUE}).}

\item{lab.size}{Size to be used for the correlation coefficient labels
(applicable only when \code{lab = TRUE}).}

\item{insig}{Character used to show specialized insignificant correlation
coefficients (\code{"pch"} (default) or \code{"blank"}). If \code{"blank"}, the
corresponding glyphs will be removed; if "pch" is used, characters (see
\code{?pch} for details) will be added on the corresponding glyphs.}

\item{pch}{Decides the glyphs (read point shapes) to be used for
insignificant correlation coefficients (only valid when \code{insig = "pch"}).
Default value is \code{pch = 4}.}

\item{pch.col, pch.cex}{The color and the cex (size) of \code{pch} (only valid when
\code{insig = "pch"}). Defaults are \code{pch.col = "#F0E442"} and \code{pch.cex = 10}.}

\item{tl.cex, tl.col, tl.srt}{The size, the color, and the string rotation of
text label (variable names, i.e.).}

\item{axis.text.x.margin.t, axis.text.x.margin.r, axis.text.x.margin.b, axis.text.x.margin.l}{Margins between x-axis and the variable name texts (t: top, r: right, b:
bottom, l:left), especially useful in case the names are slanted, i.e. when
the tl.srt is between \code{45} and \code{75} (Defaults: \code{0}, \code{0}, \code{0}, \code{0}, resp.).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\value{
Correlation matrix plot or correlation coefficient matrix or matrix
of p-values.
}
\description{
Visualization of a correlalogram (or correlation matrix)
}
\examples{

# for reproducibility
set.seed(123)

# if `cor.vars` not specified, all numeric varibles used
ggstatsplot::ggcorrmat(data = iris)

# to get the correlalogram
# note that the function will run even if the vector with variable names is
# not of same length as the number of variables
ggstatsplot::ggcorrmat(
  data = ggplot2::msleep,
  cor.vars = sleep_total:bodywt,
  cor.vars.names = c("total sleep", "REM sleep")
) + # further modification using `ggplot2`
  ggplot2::scale_y_discrete(position = "right")

# to get the correlation matrix
ggstatsplot::ggcorrmat(
  data = ggplot2::msleep,
  cor.vars = sleep_total:bodywt,
  output = "r"
)

# setting output = "p-values" (or "p") will return the p-value matrix
ggstatsplot::ggcorrmat(
  data = ggplot2::msleep,
  cor.vars = sleep_total:bodywt,
  corr.method = "r",
  p.adjust.method = "bonferroni",
  output = "p"
)

# setting `output = "ci"` will return the confidence intervals for unique
# correlation pairs
ggstatsplot::ggcorrmat(
  data = ggplot2::msleep,
  cor.vars = sleep_total:bodywt,
  p.adjust.method = "BH",
  output = "ci"
)

# modifying elements of the correlation matrix by changing function defaults
ggstatsplot::ggcorrmat(
  data = datasets::iris,
  cor.vars = c(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width),
  sig.level = 0.01,
  ggtheme = ggplot2::theme_bw(),
  hc.order = TRUE,
  matrix.type = "lower",
  outline.col = "white",
  title = "Dataset: Iris"
)
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggcorrmat.html}
}
\seealso{
\code{\link{grouped_ggcorrmat}} \code{\link{ggscatterstats}}
\code{\link{grouped_ggscatterstats}}
}
\author{
Indrajeet Patil
}
