% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_subtitles.R
\name{subtitle_ggbetween_anova_parametric}
\alias{subtitle_ggbetween_anova_parametric}
\title{Making text subtitle for the between-subject anova designs.}
\usage{
subtitle_ggbetween_anova_parametric(data, x, y,
  effsize.type = "partial_omega", nboot = 100, var.equal = FALSE,
  k = 3, messages = TRUE)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{The grouping variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d} for \strong{t-test};
\code{"partial_eta"} for partial eta-squared for \strong{anova}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}; \code{"partial_omega"} for partial
omega-squared for \strong{anova})).}

\item{nboot}{Number of bootstrap samples for computing effect size (Default:
\code{100}).}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{k}{Number of digits after decimal point (should be an integer) (Default: \code{k = 3}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Making text subtitle for the between-subject anova designs.
}
\examples{
# with defaults
subtitle_ggbetween_anova_parametric(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem
)

# modifying the defaults
subtitle_ggbetween_anova_parametric(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  effsize.type = "partial_eta",
  k = 2,
  var.equal = TRUE,
  nboot = 10
)
}
\author{
Indrajeet Patil
}
