% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_gghistostats_subtitles.R
\name{subtitle_t_onesample}
\alias{subtitle_t_onesample}
\title{Making text subtitle for one sample t-test and its nonparametric and
robust equivalents.}
\usage{
subtitle_t_onesample(data, x, type = "parametric", test.value = 0,
  bf.prior = 0.707, robust.estimator = "onestep", effsize.type = "g",
  effsize.noncentral = TRUE, conf.level = 0.95, conf.type = "norm",
  nboot = 100, k = 2, messages = TRUE, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{A numeric variable.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{robust.estimator}{If \code{test = "robust"} robust estimator to be used
(\code{"onestep"} (Default), \code{"mom"}, or \code{"median"}). For more, see
\code{?WRS2::onesampb}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}). The default is}

\item{effsize.noncentral}{Logical indicating whether to use non-central
\emph{t}-distributions for computing the confidence interval for Cohen's \emph{d}
or Hedge's \emph{g} (Default: \code{TRUE}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Additional arguments.}
}
\description{
Making text subtitle for one sample t-test and its nonparametric and
robust equivalents.
}
\examples{

# for reproducibility
set.seed(123)

ggstatsplot::subtitle_t_onesample(
  data = iris,
  x = Sepal.Length,
  test.value = 5,
  type = "r"
)
}
\seealso{
\code{\link{gghistostats}}
}
\author{
Indrajeet Patil
}
