% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-filter-spct.R
\name{Rfr_specular_label}
\alias{Rfr_specular_label}
\alias{Rfr_total_label}
\title{Reflectance axis labels}
\usage{
Rfr_specular_label(unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"))

Rfr_total_label(unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"))
}
\arguments{
\item{unit.exponent}{integer}

\item{format}{character string, "R", "R.expresion", "R.character", or
"LaTeX".}
}
\value{
a character string or an R expression.
}
\description{
Generate spectral reflectance labels in SI units,
using SI scale factors. Output can be selected as character, expression (R
default devices) or LaTeX (for tikz device).
}
\examples{
Rfr_specular_label()
Rfr_specular_label(3)
Rfr_specular_label(format = "R.expression")
Rfr_specular_label(format = "LaTeX")
Rfr_specular_label(3, format = "LaTeX")

Rfr_total_label()
Rfr_total_label(-2)
Rfr_total_label(-3)
Rfr_total_label(format = "R.expression")
Rfr_total_label(format = "LaTeX")
Rfr_total_label(-2, format = "LaTeX")
Rfr_total_label(-3, format = "LaTeX")

}
