% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{plot_density}
\alias{plot_density}
\title{A density of a single variable.}
\usage{
plot_density(
  output,
  parameter,
  dimension = 1,
  target = NULL,
  external_target = NULL,
  use_initial_points = TRUE,
  use_weights = TRUE,
  xlimits = NULL,
  ylimits = NULL,
  default_title = FALSE
)
}
\arguments{
\item{output}{Output from the SMC or EnK algorithm.}

\item{parameter}{The parameter for which we wish to view the density.}

\item{dimension}{(optional) The dimension of the parameter for which we wish to view the density. (default is 1)}

\item{target}{(optional) The index of the target for which we wish to view the density. (default to all targets)}

\item{external_target}{(optional) The index of the external target to plot. (default is to use all external targets, or to ignore if the column is not present)}

\item{use_initial_points}{(optional) If target is not specified and this argument is TRUE, will add the initial unweighted proposed points to the output to be plotted. (default is TRUE)}

\item{use_weights}{(optional) If FALSE, will ignore particle weights in the density. If TRUE, will use the particle weights. (defaults to TRUE)}

\item{xlimits}{(optional) Input of the form c(start,end), which specifies the ends of the x-axis.}

\item{ylimits}{(optional) Input of the form c(start,end), which specifies the ends of the y-axis.}

\item{default_title}{(optional) If TRUE, will provide a default title for the figure. If FALSE, no title is used. (defaults to FALSE)}
}
\value{
A density in a ggplot figure.
}
\description{
A density of a single variable.
}
