% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseqtrplot.R
\name{ggseqtrplot}
\alias{ggseqtrplot}
\title{Sequence Transition Rate Plot}
\usage{
ggseqtrplot(
  seqdata,
  dss = TRUE,
  group = NULL,
  no.n = FALSE,
  weighted = TRUE,
  with.missing = FALSE,
  labsize = NULL,
  axislabs = "labels",
  x_n.dodge = 1,
  facet_ncol = NULL,
  facet_nrow = NULL
)
}
\arguments{
\item{seqdata}{State sequence object (class \code{stslist}) created with the \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function.}

\item{dss}{specifies if transition rates are computed for STS or DSS (default) sequences}

\item{group}{A vector of the same length as the sequence data indicating group membership. When not NULL, a distinct plot is generated for each level of group.}

\item{no.n}{specifies if number of (weighted) sequences is shown in grouped (faceted) graph}

\item{weighted}{Controls if weights (specified in \code{\link[TraMineR:seqdef]{TraMineR::seqdef}}) should be used. Default is \code{TRUE}, i.e. if available weights are used}

\item{with.missing}{Specifies if missing state should be considered when computing the transition rates (default is \code{FALSE}).}

\item{labsize}{Specifies the font size of the labels within the tiles (if not specified ggplot2's default is used)}

\item{axislabs}{specifies if sequence object's long "labels" (default) or the state names from its "alphabet" attribute should be used.}

\item{x_n.dodge}{allows to print the labels of the x-axis in multiple rows to avoid overlapping.}

\item{facet_ncol}{Number of columns in faceted (i.e. grouped) plot}

\item{facet_nrow}{Number of rows in faceted (i.e. grouped) plot}
}
\value{
A tile plot of transition rates.
}
\description{
Function for plotting transition rate matrix of sequence states internally
computed by \code{\link[TraMineR:seqtrate]{TraMineR::seqtrate}} \insertCite{gabadinho2011}{ggseqplot}.
Plot is generated using \code{\link[ggplot2]{ggplot2}} \insertCite{wickham2016}{ggseqplot}.
}
\details{
The transition rates are obtained by an internal call of
\code{\link[TraMineR:seqtrate]{TraMineR::seqtrate}}.
This requires that the input data (\code{seqdata})
are stored as state sequence object (class \code{stslist}) created with
the \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function.
As STS based transition rates tend to be dominated by high values on the diagonal, it might be
worthwhile to examine DSS sequences instead (\code{dss = TRUE})). In this case the resulting
plot shows the transition rates between episodes of distinct states.

In any case (DSS or STS) the transitions rates are reshaped into a a long data format
to enable plotting with \code{\link[ggplot2]{ggplot2}}. The resulting output then is
prepared to be plotted with  \code{\link[ggplot2:geom_tile]{ggplot2::geom_tile}}.
The data and specifications used for rendering the plot can be obtained by storing the
plot as an object. The appearance of the plot can be adjusted just like with
every other ggplot (e.g., by changing the theme or the scale using \code{+} and
the respective functions).
}
\examples{
# Use example data from TraMineR: biofam data set
data(biofam)

# We use only a sample of 300 cases
set.seed(10)
biofam <- biofam[sample(nrow(biofam),300),]
biofam.lab <- c("Parent", "Left", "Married", "Left+Marr",
                "Child", "Left+Child", "Left+Marr+Child", "Divorced")
biofam.seq <- seqdef(biofam, 10:25, labels=biofam.lab, weights = biofam$wp00tbgs)

# Basic transition rate plot (with adjusted x-axis labels)
ggseqtrplot(biofam.seq, x_n.dodge = 2)

# Transition rate with group variable (with and without weights)
ggseqtrplot(biofam.seq, group=biofam$sex, x_n.dodge = 2)
ggseqtrplot(biofam.seq, group=biofam$sex, x_n.dodge = 2, weighted = FALSE)

}
\references{
\insertAllCited{}
}
\author{
Marcel Raab
}
