% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\name{geometry}
\alias{geometry}
\alias{circle}
\alias{square}
\alias{ellipsis}
\alias{rectangle}
\alias{label_rect}
\alias{is.geometry}
\title{Define simple shapes for line capping}
\usage{
geometry(type = "circle", width = 1, height = width,
  width_unit = "cm", height_unit = width_unit)

circle(radius = 1, unit = "cm")

square(length = 1, unit = "cm")

ellipsis(a = 1, b = 1, a_unit = "cm", b_unit = a_unit)

rectangle(width = 1, height = 1, width_unit = "cm",
  height_unit = width_unit)

label_rect(label, padding = margin(1, 1, 1.5, 1, "mm"), ...)

is.geometry(x)
}
\arguments{
\item{type}{The type of geometry to use. Currently \code{'circle'} and
\code{'rect'} is supported.}

\item{width, height, length, radius, a, b}{The dimensions of the shape.}

\item{unit, width_unit, height_unit, a_unit, b_unit}{The unit for the numbers
given.}

\item{label}{The text to be enclosed}

\item{padding}{extra size to be added around the text using the
\code{\link[ggplot2:margin]{ggplot2::margin()}} function}

\item{...}{Passed on to \code{\link[grid:gpar]{grid::gpar()}}}

\item{x}{An object to test for geometry inheritance}
}
\value{
A geometry object encoding the specified shape.
}
\description{
This set of functions makes it easy to define shapes at the terminal points
of edges that are used to shorten the edges. The shapes themselves are not
drawn, but the edges will end at the boundary of the shape rather than at
the node position. This is especially relevant when drawing arrows at the
edges as the arrows will be partly obscured by the node unless the edge is
shortened. Edge shortening is dynamic and will update as the plot is resized,
making sure that the capping remains at an absolute distance to the end
point.
}
\details{
\code{geometry} is the base constructor, while the rest are helpers to save
typing. \code{circle} creates circles width a given radius, \code{square}
creates squares at a given side length, \code{ellipsis} creates ellipses with
given a and b values (width and height radii), and \code{rectangle} makes
rectangles of a given width and height. label_rect is a helper that, given
a list of strings and potentially formatting options creates a rectangle that
encloses the string.
}
\examples{
geometry(c('circle', 'rect', 'rect'), 1:3, 3:1)

circle(1:4, 'mm')

label_rect(c('some', 'different', 'words'), fontsize = 18)
}
