% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_scale.R
\name{axis_scale}
\alias{axis_scale}
\alias{xscale}
\alias{yscale}
\title{Change Axis Scale: log2, log10 and more}
\usage{
xscale(.scale, .format = FALSE)

yscale(.scale, .format = FALSE)
}
\arguments{
\item{.scale}{axis scale. Allowed values are one of c("none", "log2", "log10",
"sqrt", "percent", "dollar", "scientific"); e.g.: .scale="log2".}

\item{.format}{ogical value. If TRUE, axis tick mark labels will be formatted
when .scale  = "log2" or "log10".}
}
\description{
Change axis scale.
\itemize{
\item \code{xscale}: change x axis scale.
\item \code{yscale}: change y axis scale.
}
}
\examples{
# Basic scatter plots
data(cars)
p <- ggscatter(cars, x = "speed", y = "dist")
p

# Set log scale
p + yscale("log2", .format = TRUE)
}
