% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-npc.r
\name{compute_npcx}
\alias{compute_npcx}
\alias{compute_npcy}
\title{Compute npc coordinates}
\usage{
compute_npcx(x, group = 1L, h.step = 0.1, margin.npc = 0.05, each.len = 1)

compute_npcy(y, group = 1L, v.step = 0.1, margin.npc = 0.05, each.len = 1)
}
\arguments{
\item{x, y}{numeric or character vector of coordinates.}

\item{group}{integer ggplot's group id. Used to shift coordinates to avoid
overlaps.}

\item{h.step, v.step}{numeric [0..1] The step size for shifting coordinates
in npc units.}

\item{margin.npc}{numeric [0..1] The margin added towards the nearest
plotting area edge when converting character coordinates into npc.}

\item{each.len}{integer The number of steps per group.}
}
\value{
A numeric vector with values in the range [0..1] representing
  npc coordinates.
}
\description{
Convert character-encoded positions to npc units and shift positions to
avoid overlaps when grouping is active. If numeric validate npc values.
}
\keyword{internal}
