% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-plot.R
\name{geom_plot}
\alias{geom_plot}
\alias{geom_plot_npc}
\title{Inset plots}
\usage{
geom_plot(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  nudge_x = 0,
  nudge_y = 0,
  add.segments = TRUE,
  arrow = NULL,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)

geom_plot_npc(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific data set - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{add.segments}{logical Display connecting segments or arrows between
original positions and displaced ones if both are available.}

\item{arrow}{specification for arrow heads, as created by
\code{\link[grid]{arrow}}}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A plot layer instance.
}
\description{
\code{geom_plot} and \code{geom_plot_npc} add ggplot objects as insets to the
base ggplot, using syntax similar to that of
\code{\link[ggplot2]{geom_label}}  and \code{\link{geom_text_s}}. In most
respects they behave as any other ggplot geometry: a layer con contain
multiple tables and faceting works as usual.
}
\details{
You can modify the size of inset plots with the \code{vp.width} and
  \code{vp.height} aesthetics. These can take a number between 0 (smallest
  possible inset) and 1 (whole plotting area width or height). The default
  value for for both of these aesthetics is 1/5. Thus, in contrast to
  \code{\link[ggplot2]{geom_text}} and \code{\link{geom_text_s}} the size of
  the insets remains the same relative to the size of the plotting area
  irrespective of how the plot is rendered. The aspect ratio of insets is
  preserved and size is adjusted until the whole inset fits within the
  viewport.

  By default this geom uses \code{\link{position_nudge_center}} which is
  backwards compatible with \code{\link[ggplot2]{position_nudge}} but
  provides additional control on the direction of the nudging. In contrast to
  \code{\link[ggplot2]{position_nudge}}, \code{\link{position_nudge_center}}
  and all other position functions defined in packages 'ggpp' and 'ggrepel'
  keep the original coordinates thus allowing the plotting of connecting
  segments and arrows.

  This geom works only with tibbles as \code{data}, as its expects a list of
  ggplot objects (\code{"gg"} class) to be mapped to the \code{label}
  aesthetic.

  The \code{x} and \code{y} aesthetics determine the position of the whole
  inset plot, similarly to that of a text label, justification is interpreted
  as indicating the position of the plot with respect to its x and y
  coordinates in the data, and \code{angle} is used to rotate the plot as a
  whole.

  In the case of \code{geom_table_npc()}, \code{npcx} and \code{npcy}
  aesthetics determine the position of the inset plot. Justification as
  described above for .

  Use \code{\link{annotate}} as redefined in 'ggpp' when adding inset plots
  as annotations (automatically available unless 'ggpp' is not attached).
  \code{\link[ggplot2]{annotate}} cannot be used with \code{geom = "plot"}.

The "width" and "height" of an inset as for a text element are 0, so
  stacking and dodging inset plots will not work by default, and axis limits
  are not automatically expanded to include all inset plots. Obviously,
  insets do have height and width, but they are physical units, not data
  units. The amount of space they occupy on the main plot is not constant in
  data units of the base plot: when you modify scale limits, inset plots stay
  the same size relative to the physical size of the base plot.
}
\note{
The inset plots are stored nested within the main ggplot object and
  contain their own copy of the data are rendered as grid grobs as normal
  ggplots at the time the main ggplot is rendered. They can have different
  themes.
}
\section{Alignment}{
 You can modify the alignment of the plot with the `vjust`
  and `hjust` aesthetics. These can either be a number between 0
  (right/bottom) and 1 (top/left) or a character (\code{"left"},
  \code{"middle"}, \code{"right"}, \code{"bottom"}, \code{"center"},
  \code{"top"}). In addition, you can use special alignments for
  justification including \code{"inward"} and \code{"outward"}. Inward always
  aligns text towards the center of the plotting area, and outward aligns it
  away from the center of the plotting area. If tagged with \code{_mean} or
  \code{_median} (e.g., \code{"outward_mean"}) the mean or median of the data
  in the panel along the corresponding axis is used as center. If the
  characters following the underscore represent a number (e.g.,
  \code{"outward_10.5"}) the reference point will be this value in data
  units.
}

\section{Known problem!}{
 In some cases when explicit coordinates are added to
  the inner plot, it may be also necessary to add explicitly coordinates to
  the outer plots.
}

\examples{
# inset plot with enlarged detail from a region of the main plot
library(tibble)
p <-
  ggplot(data = mtcars, mapping = aes(wt, mpg)) +
  geom_point()

df <- tibble(x = 0.01,
             y = 0.01,
             plot = list(p +
                         coord_cartesian(xlim = c(3, 4),
                                         ylim = c(13, 16)) +
                         labs(x = NULL, y = NULL) +
                         theme_bw(10)))
p +
  expand_limits(x = 0, y = 0) +
  geom_plot_npc(data = df,
                aes(npcx = x, npcy = y, label = plot))

p +
  expand_limits(x = 0, y = 0) +
  geom_plot_npc(data = df,
                aes(npcx = x, npcy = y, label = plot,
                vp.width = 1/2, vp.height = 1/4))

p +
  expand_limits(x = 0, y = 0) +
  geom_plot_npc(data = df,
                aes(npcx = x, npcy = y, label = plot),
                vp.width = 1/4, vp.height = 1/4)

p +
  geom_plot(data = df,
            aes(x = x + 3, y = y + 20, label = plot),
            nudge_x = -1, nudge_y = - 7,
            hjust = 0.5, vjust = 0.5,
            arrow = arrow(length = unit(0.5, "lines")),
            segment.colour = "red",
            vp.width = 1/5, vp.height = 1/5)

}
\references{
The idea of implementing a \code{geom_custom()} for grobs has
  been discussed as an issue at
  \url{https://github.com/tidyverse/ggplot2/issues/1399}.
}
\seealso{
\code{\link{geom_plot}}, \code{\link{geom_table}},
  \code{\link{annotate}}, \code{\link{position_nudge_keep}},
  \code{\link{position_nudge_to}}, \code{\link{position_jitternudge}},
  \code{\link{position_dodgenudge}} and \code{\link{position_stacknudge}}.

Other geometries adding layers with insets: 
\code{\link{geom_grob}()},
\code{\link{geom_table}()}
}
\concept{geometries adding layers with insets}
