% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-nodes.R
\name{geom_nodetext_repel}
\alias{geom_nodetext_repel}
\alias{geom_nodelabel_repel}
\title{Draw repulsive node labels}
\usage{
geom_nodetext_repel(
  mapping = NULL,
  data = NULL,
  parse = FALSE,
  ...,
  box.padding = unit(0.25, "lines"),
  point.padding = unit(1e-06, "lines"),
  arrow = NULL,
  force = 1,
  max.iter = 10000,
  nudge_x = 0,
  nudge_y = 0,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_nodelabel_repel(
  mapping = NULL,
  data = NULL,
  parse = FALSE,
  ...,
  box.padding = unit(0.25, "lines"),
  label.padding = unit(0.25, "lines"),
  point.padding = unit(1e-06, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0.25,
  arrow = NULL,
  force = 1,
  max.iter = 10000,
  nudge_x = 0,
  nudge_y = 0,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}} or
\code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in ?plotmath}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There are
  three types of arguments you can use here:

  \itemize{
    \item Aesthetics: to set an aesthetic to a fixed value, like
       \code{colour = "red"} or \code{size = 3}.
    \item Other arguments to the layer, for example you override the
      default \code{stat} associated with the layer.
    \item Other arguments passed on to the stat.
  }}

\item{box.padding}{Amount of padding around bounding box, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}

\item{point.padding}{Amount of padding around labeled point, as unit or
number. Defaults to 0. (Default unit is lines, but other units can be
specified by passing \code{unit(x, "units")}).}

\item{arrow}{specification for arrow heads, as created by \code{\link[grid]{arrow}}}

\item{force}{Force of repulsion between overlapping text labels. Defaults
to 1.}

\item{max.iter}{Maximum number of iterations to try to resolve overlaps.
Defaults to 10000.}

\item{nudge_x}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{label.padding}{Amount of padding around label, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}

\item{label.r}{Radius of rounded corners, as unit or number. Defaults
to 0.15. (Default unit is lines, but other units can be specified by
passing \code{unit(x, "units")}).}

\item{label.size}{Size of label border, in mm.}
}
\description{
All arguments to these geoms are identical to those of
\code{\link[ggrepel]{geom_text_repel}} and
\code{\link[ggrepel]{geom_label_repel}}.
}
\examples{
## geom_nodetext_repel example

if (require(network) && require(sna)) {
  n <- network(rgraph(10, tprob = 0.2), directed = FALSE)
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "steelblue") +
    geom_nodetext_repel(aes(label = paste("node", vertex.names)),
      box.padding = unit(1, "lines")
    ) +
    geom_nodes(colour = "steelblue", size = 3) +
    theme_blank()
}

## geom_nodelabel_repel examples

if (require(network) && require(sna)) {
  data(flo, package = "network")
  n <- network(flo, directed = FALSE)

  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "steelblue") +
    geom_nodelabel_repel(aes(label = vertex.names),
      box.padding = unit(1, "lines")
    ) +
    geom_nodes(colour = "steelblue", size = 3) +
    theme_blank()

  # label only a subset of all nodes
  n \%v\% "degree" <- degree(n)
  low_degree <- function(x) {
    x[ x$degree < median(x$degree), ]
  }
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(colour = "steelblue") +
    geom_nodelabel_repel(aes(label = vertex.names),
      box.padding = unit(1.5, "lines"),
      data = low_degree,
      segment.colour = "tomato",
      colour = "white", fill = "tomato"
    ) +
    geom_nodes(aes(size = degree), colour = "steelblue") +
    theme_blank()
}

}
