% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MullerPlot.R
\name{Muller_plot}
\alias{Muller_plot}
\title{Draw a Muller plot of frequencies using ggplot2}
\usage{
Muller_plot(Muller_df, colour_by = NA, palette = NA, add_legend = FALSE,
  xlab = "Generation", ylab = "Frequency", pop_plot = FALSE)
}
\arguments{
\item{Muller_df}{Dataframe created by get_Muller_df}

\item{colour_by}{Character containing name of column by which to colour the plot}

\item{palette}{List of colours}

\item{add_legend}{Logical whether to show legend}

\item{xlab}{Label of x axis}

\item{ylab}{Label of y axis}

\item{pop_plot}{Logical for whether this function is being called from Muller_pop_plot (otherwise should be FALSE)}
}
\value{
None
}
\description{
Draw a Muller plot of frequencies using ggplot2
}
\examples{
# include all genotypes:
Muller_df1 <- get_Muller_df(example_edges, example_pop_df)
Muller_plot(Muller_df1)
# omit genotypes with max frequency < 0.1:
Muller_df2 <- get_Muller_df(example_edges, example_pop_df, threshold = 0.1)
Muller_plot(Muller_df2)

}
\seealso{
\code{\link{get_Muller_df}} \code{\link{Muller_pop_plot}}
}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
