% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheduler.R
\name{ggml_backend_sched_reserve}
\alias{ggml_backend_sched_reserve}
\title{Reserve memory for scheduler}
\usage{
ggml_backend_sched_reserve(sched, graph)
}
\arguments{
\item{sched}{Scheduler pointer}

\item{graph}{Graph pointer to measure memory requirements}
}
\value{
Logical indicating success
}
\description{
Pre-allocates memory based on a measurement graph. This should be called
before using the scheduler to compute graphs.
}
\examples{
\donttest{
cpu <- ggml_backend_cpu_init()
sched <- ggml_backend_sched_new(list(cpu))
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 1000)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 1000)
c <- ggml_add(ctx, a, b)
graph <- ggml_build_forward_expand(ctx, c)
ggml_backend_sched_reserve(sched, graph)
ggml_backend_sched_free(sched)
ggml_backend_free(cpu)
ggml_free(ctx)
}
}
