% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_inset_frame.R
\name{geom_inset_frame}
\alias{geom_inset_frame}
\title{Add a frame and burst lines for an inset}
\usage{
geom_inset_frame(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "sf_inset",
  position = "identity",
  ...,
  inset = NA,
  na.rm = FALSE,
  source.aes = list(),
  target.aes = list(),
  lines.aes = list(),
  show.legend = NA,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.}

\item{inset}{Inset configuration; see \code{\link[=configure_inset]{configure_inset()}}.
If \code{NA} (the default), this is inherited from the coord (see \code{\link[=coord_sf_inset]{coord_sf_inset()}}).}

\item{source.aes, target.aes, lines.aes}{Override the aesthetics of the
inset source, target, and lines respectively. The value should be a list
named by the aesthetics, and the values should be scalars of length one.}
}
\value{
A ggplot layer holding the inset frame.
}
\description{
Add a frame and burst lines for an inset
}
\section{Limitation}{

The frame cannot be drawn without another sf layer that contains data due to
a limitation of the ggplot layout evaluation. Attempting to plot a frame by
itself will result in the error:
"Scale limits cannot be mapped onto spatial coordinates in \code{coord_sf()}".
}

\examples{
library(ggplot2)

nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

ggplot(nc) +
  geom_sf_inset() +
  geom_inset_frame() +
  coord_sf_inset(inset = configure_inset(
    centre = sf::st_sfc(sf::st_point(c(-82, 35)), crs = 4326),
    scale = 2, translation = c(0, -300), radius = 50, units = "mi"))
}
