% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revgeocode.R
\name{revgeocode}
\alias{revgeocode}
\title{Reverse geocode}
\usage{
revgeocode(location, output = c("address", "all"), force = FALSE,
  urlonly = FALSE, override_limit = FALSE, ext = "com",
  inject = "", ...)
}
\arguments{
\item{location}{a location in longitude/latitude format}

\item{output}{"address" or "all"}

\item{force}{force online query, even if cached (previously downloaded)}

\item{urlonly}{return only the url?}

\item{override_limit}{override the current query rate}

\item{ext}{domain extension (e.g. "com", "co.nz")}

\item{inject}{character string to add to the url}

\item{...}{...}
}
\value{
a character(1) address or a list (the parsed json output from Google)
}
\description{
Reverse geocodes (looks up the address of) a longitude/latitude location
using the Google Geocoding API. Note: To use Google's Geocoding API, you must
first enable the API in the Google Cloud Platform Console. See
\code{?register_google}.
}
\examples{

\dontrun{ requires Google API key, see ?register_google

## basic usage
########################################

( gc <- as.numeric(geocode("the white house")) )
revgeocode(gc)
str(revgeocode(gc, output = "all"), 3)

}

}
\seealso{
\url{http://code.google.com/apis/maps/documentation/geocoding/}
}
\author{
David Kahle \email{david.kahle@gmail.com}
}
