% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_drawer.R
\name{file_drawer}
\alias{file_drawer}
\title{Manage the ggmap file drawer.}
\usage{
file_drawer(...)
}
\description{
To avoid downloading the same maps again and again, ggmap uses a
"file drawer" to store the maps you've downloaded. By default,
they will be stored in a session specific temporary directory
which will be deleted each time you quit R. If you want them to
persist across sessions, set the global option
"ggmap.file_drawer".
}
\examples{

\dontrun{ if server is unresponsive, R check will fail

file_drawer()
dir(file_drawer())

# The first time you run this, the tiles are downloaded from the server
map <- get_stamenmap()
# The second time, the local cache is used so it's much faster
map <- get_stamenmap()

dir(file_drawer())

}

}
\keyword{internal}
