% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stamenmap.R
\name{get_stamenmap}
\alias{get_stamenmap}
\title{Get a Stamen Map}
\usage{
get_stamenmap(bbox = c(left = -95.80204, bottom = 29.38048, right = -94.92313,
  top = 30.14344), zoom = 10, maptype = c("terrain", "terrain-background",
  "terrain-labels", "terrain-lines", "toner", "toner-2010", "toner-2011",
  "toner-background", "toner-hybrid", "toner-labels", "toner-lines",
  "toner-lite", "watercolor"), crop = TRUE, messaging = FALSE,
  urlonly = FALSE, color = c("color", "bw"), force = FALSE,
  where = tempdir(), ...)
}
\arguments{
\item{bbox}{a bounding box in the format c(lowerleftlon,
lowerleftlat, upperrightlon, upperrightlat).}

\item{zoom}{a zoom level}

\item{maptype}{terrain, terrain-background, terrain-labels,
terrain-lines, toner, toner-2010, toner-2011, toner-background,
toner-hybrid, toner-labels, toner-lines, toner-lite, or
watercolor.}

\item{crop}{crop raw map tiles to specified bounding box}

\item{messaging}{turn messaging on/off}

\item{urlonly}{return url only}

\item{color}{color or black-and-white}

\item{force}{if the map is on file, should a new map be looked
up?}

\item{where}{where should the file drawer be located (without
terminating "/")}

\item{...}{...}
}
\value{
a ggmap object (a classed raster object with a bounding
  box attribute)
}
\description{
\code{get_stamenmap} accesses a tile server for Stamen Maps and
downloads/stitches map tiles/formats a map image. Note that
Stamen maps don't cover the entire world, e.g.
\url{http://tile.stamen.com/terrain/#4/30.28/-87.21}
}
\examples{

\dontrun{ # to diminish run check time

gc <- geocode("baylor university")
google <- get_googlemap("baylor university", zoom = 15)
ggmap(google) +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)

bbox <- c(left = -97.132, bottom = 31.536, right = -97.105, top = 31.560)
ggmap(get_stamenmap(bbox, zoom = 13))
ggmap(get_stamenmap(bbox, zoom = 14))
ggmap(get_stamenmap(bbox, zoom = 15))
# ggmap(get_stamenmap(bbox, zoom = 16))
# ggmap(get_stamenmap(bbox, zoom = 17))

# note that the osm code may not run due to overloaded
# servers.

# various maptypes are available.  bump it up to zoom = 15 for better resolution.
ggmap(get_stamenmap(bbox, maptype = "terrain", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "terrain-background", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "terrain-labels", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "terrain-lines", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "toner", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "toner-2010", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "toner-2011", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "toner-background", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "toner-hybrid", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "toner-labels", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "toner-lines", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "toner-lite", zoom = 14))
ggmap(get_stamenmap(bbox, maptype = "watercolor", zoom = 14))

ggmap(get_stamenmap(bbox, maptype = "watercolor", zoom = 11), extent = "device")
ggmap(get_stamenmap(bbox, maptype = "watercolor", zoom = 12), extent = "device")
ggmap(get_stamenmap(bbox, maptype = "watercolor", zoom = 13), extent = "device")
ggmap(get_stamenmap(bbox, maptype = "watercolor", zoom = 14), extent = "device")
# ggmap(get_stamenmap(bbox, maptype = "watercolor", zoom = 15), extent = "device")
# ggmap(get_stamenmap(bbox, maptype = "watercolor", zoom = 16), extent = "device")
# ggmap(get_stamenmap(bbox, maptype = "watercolor", zoom = 17), extent = "device")
# ggmap(get_stamenmap(bbox, maptype = "watercolor", zoom = 18), extent = "device")

stamen <- get_stamenmap(bbox, zoom = 15)
ggmap(stamen) +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)

stamen <- get_stamenmap(bbox, zoom = 15, crop = FALSE)
ggmap(stamen) +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)


osm <- get_openstreetmap(bbox, scale = OSM_scale_lookup(15))
ggmap(osm) +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)


ggmap(get_stamenmap(bbox, zoom = 15, maptype = "watercolor"))+
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)

ggmap(get_stamenmap(bbox, zoom = 15, maptype = "toner"))+
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)


# here's an interesting example:
us <- c(left = -125, bottom = 25.75, right = -67, top = 49)
map <- get_stamenmap(us, zoom = 5, maptype = "toner-labels")
ggmap(map)



# accuracy check - white house
gc <- geocode("the white house")

qmap("the white house", zoom = 16)  +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 3)

qmap("the white house", zoom = 16, source = "stamen", maptype = "terrain")  +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 3)





# accuracy check - statue of liberty
# see https://github.com/dkahle/ggmap/issues/32

gc <- geocode("statue of liberty")

googMapZ10 <- get_googlemap(center = as.numeric(gc))
bbZ10 <- attr(googMapZ10, "bb")
stamMapZ10 <- get_stamenmap(bb2bbox(bbZ10))

ggmap(googMapZ10) +
  geom_point(
    aes(x = lon, y = lat),
    data = gc, colour = "red", size = 3
  )

ggmap(stamMapZ10) +
  geom_point(
    aes(x = lon, y = lat),
    data = gc, colour = "red", size = 3
)


# using a higher zoom
googMapZ15 <- get_googlemap(center = as.numeric(gc), zoom = 15)
bbZ15 <- attr(googMapZ15, "bb")
stamMapZ15 <- get_stamenmap(bb2bbox(bbZ15),
  zoom = calc_zoom(bb2bbox(bbZ15))
)

ggmap(googMapZ15) +
  geom_point(
    aes(x = lon, y = lat),
    data = gc, colour = "red", size = 3
)

ggmap(stamMapZ15) +
  geom_point(
    aes(x = lon, y = lat),
    data = gc, colour = "red", size = 3
  )


# using a lower zoom
googMapZ5 <- get_googlemap(center = as.numeric(gc), zoom = 4)
bbZ5 <- attr(googMapZ5, "bb")
stamMapZ5 <- get_stamenmap(bb2bbox(bbZ5),
  zoom = calc_zoom(bb2bbox(bbZ5))
)

ggmap(googMapZ5) +
  geom_point(
    aes(x = lon, y = lat),
    data = gc, colour = "red", size = 3
  )

ggmap(stamMapZ5) +
  geom_point(
    aes(x = lon, y = lat),
    data = gc, colour = "red", size = 3
  )


stamMapZ5unCropped <- get_stamenmap(bb2bbox(bbZ5),
  zoom = calc_zoom(bb2bbox(bbZ5)),
  crop = FALSE)

ggmap(stamMapZ5unCropped) +
  geom_point(
    aes(x = lon, y = lat),
    data = gc, colour = "red", size = 3
  )

qmap(location = c(lon = -74.0445, lat = 40.68925),
    zoom = 16, source = "stamen")  +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 3)

} # end dontrun

}
\seealso{
\url{http://maps.stamen.com/#watercolor},
  \code{\link{ggmap}}
}

