% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_cooks_leverage.R
\name{stat_cooks_leverage}
\alias{stat_cooks_leverage}
\title{stat_cooks_leverage}
\usage{
stat_cooks_leverage(
  alpha = 0.5,
  method = "loess",
  color = "steelblue",
  se = FALSE,
  ...
)
}
\arguments{
\item{alpha}{Adjust transparency of points.}

\item{method}{Method for fitting the line to the points.}

\item{color}{Color of the line.}

\item{se}{Keep standard error bands around line?}

\item{...}{Currently ignored. For extendability.}
}
\value{
A `ggplot2` layer for plotting Cook's Distance vs. Leverage.
}
\description{
Cook's Distance vs. Leverage
}
\examples{
data(mtcars)
model <- lm(mpg ~ cyl + disp + hp, data = mtcars)
ggplot2::ggplot(data = model) + stat_cooks_leverage()
}
