% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPieDonut.R
\name{ggDonut}
\alias{ggDonut}
\title{Draw a Donut plot}
\usage{
ggDonut(data, mapping, addDonutLabel = TRUE, showRatio = TRUE,
  polar = TRUE, labelposition = 1, title = "", interactive = FALSE)
}
\arguments{
\item{data}{A data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{addDonutLabel}{A logical value. If TRUE, labels are added to the Donuts}

\item{showRatio}{A logical value. If TRUE, Ratios are added to the DonutLabels}

\item{polar}{A logical value. If TRUE, coord_polar() function will be added}

\item{labelposition}{A number indicating the label position}

\item{title}{Plot title}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}
}
\value{
An interactive Pie and Donut plot
}
\description{
Draw a Donut plot
}
\examples{
require(ggplot2)
require(ggiraph)
require(plyr)
ggDonut(browsers,aes(donuts=version,count=share))
}

