% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_hourglass.R
\docType{data}
\name{CoordHourglass}
\alias{CoordHourglass}
\alias{coord_hourglass}
\title{Hourglass coordinates for a ggplot}
\format{
An object of class \code{CoordHourglass} (inherits from \code{CoordCartesian}, \code{Coord}, \code{ggproto}, \code{gg}) of length 3.
}
\usage{
CoordHourglass

coord_hourglass(
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  default = FALSE,
  clip = "on",
  date_labels = "\%H:\%M",
  ...
)
}
\arguments{
\item{xlim, ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}

\item{default}{Is this the default coordinate system? If \code{FALSE} (the default),
then replacing this coordinate system with another one creates a message alerting
the user that the coordinate system is being replaced. If \code{TRUE}, that warning
is suppressed.}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}

\item{date_labels}{Formating string for formatting the time
labels on the axis. By default it is \code{"\%H:\%M"}.}

\item{...}{Arguments passed as extra \code{param}s to \code{\link[ggplot2:layer]{ggplot2::layer()}}}
}
\value{
Returns a \code{ggproto} object inheriting from \code{coord_cartesian()}.
}
\description{
A Cartesian coordinate system that adds sensible
guides to axes in a \code{geom_hourglass()} layer. It is added automatically
to \code{geom_hourglass()}. There is no need to explicitly add it to a ggplot,
unless you wish to tweak the coordinate system.
}
\examples{
coord_hourglass()
}
\author{
Pepijn de Vries
}
\keyword{datasets}
