% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_axis_minor.R
\name{guide_axis_minor}
\alias{guide_axis_minor}
\title{Axis guide with ticks for minor breaks}
\usage{
guide_axis_minor(
  title = waiver(),
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  order = 0,
  colour = NULL,
  color = NULL,
  trunc_lower = NULL,
  trunc_upper = NULL,
  position = waiver()
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{check.overlap}{silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}

\item{angle}{Compared to setting the angle in \code{\link[ggplot2:theme]{theme()}} / \code{\link[ggplot2:element_text]{element_text()}},
this also uses some heuristics to automatically pick the \code{hjust} and \code{vjust} that
you probably want.}

\item{n.dodge}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}

\item{order}{Used to determine the order of the guides (left-to-right,
top-to-bottom), if more than one  guide must be drawn at the same location.}

\item{colour, color}{A \code{character(1)} with a valid colour for colouring the
axis text, axis ticks and axis line. Overrules the colour assigned by the
theme.}

\item{trunc_lower, trunc_upper}{The lower and upper range of the truncated
axis:
\itemize{
\item \code{NULL} to not perform any truncation.
\item A \code{function} that takes the break positions as input and returns the lower
or upper boundary. Note that also for discrete scales, positions are the
mapped positions as \code{numeric}.
\item A \code{numeric} value in data units for the lower and upper boundaries.
\item A \code{unit} object.
}}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}
}
\value{
An \emph{axis_minor} guide class object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}
These are similar the the normal axis guides for position scales, but also
place tickmarks at minor break positions.
The function is questioned due to
a possible migration of guide functions after ggplot2 releases a new guide
system.
}
\section{Theme elements}{

This axis guide uses the following the theme elements:

\describe{
\item{\code{\link[=theme_extensions]{ggh4x.axis.ticks.length.minor}}}{
An \code{\link[=rel]{rel()}} object to set the size of minor ticks relative to the
length of major ticks (\code{axis.ticks.length}). Defaults to \code{rel(2/3)}.
}
}
}

\examples{
# Using the minor breaks axis
p <- ggplot(iris, aes(Sepal.Width, Sepal.Length)) +
  geom_point()
p + scale_y_continuous(guide = "axis_minor")

# Minor break positions are still controlled by the scale
p + scale_y_continuous(guide = "axis_minor",
                       minor_breaks = seq(4, 8, by = 0.2))

# Minor tick length is controlled relative to major ticks
p + scale_y_continuous(guide = "axis_minor") +
  theme(ggh4x.axis.ticks.length.minor = rel(0.1))
}
\seealso{
Other axis-guides: 
\code{\link{guide_axis_logticks}()},
\code{\link{guide_axis_manual}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_axis_scalebar}()},
\code{\link{guide_axis_truncated}()}
}
\concept{axis-guides}
