% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_nested_wrap.R
\name{facet_nested_wrap}
\alias{facet_nested_wrap}
\title{Ribbon of panels with nested strips.}
\usage{
facet_nested_wrap(
  facets,
  nrow = NULL,
  ncol = NULL,
  scales = "fixed",
  axes = "margins",
  remove_labels = "none",
  shrink = TRUE,
  labeller = "label_value",
  as.table = TRUE,
  drop = TRUE,
  dir = "h",
  strip.position = "top",
  nest_line = element_blank(),
  resect = unit(0, "mm"),
  trim_blank = TRUE,
  strip = strip_nested(),
  bleed = NULL
)
}
\arguments{
\item{facets}{A set of variables or expressions quoted by \code{\link[ggplot2:vars]{vars()}}
and defining faceting groups on the rows or columns dimension.
The variables can be named (the names are passed to \code{labeller}).

For compatibility with the classic interface, can also be a
formula or character vector. Use either a one sided formula, \code{~a + b},
or a character vector, \code{c("a", "b")}.}

\item{nrow}{Number of rows and columns.}

\item{ncol}{Number of rows and columns.}

\item{scales}{A \code{character(1)} or \code{logical(1)} whether scales are shared
across facets or allowed to vary. One of the following:
\describe{
\item{\code{"fixed"} or \code{FALSE}}{Scales are shared across all facets
(default).}
\item{\code{"free_x"}}{x-scales are allowed to vary.}
\item{\code{"free_y"}}{y-scales are allowed to vary.}
\item{\code{"free"} or \code{TRUE}}{Both scales can vary}
}}

\item{axes}{A \code{character(1)} or \code{logical(1)} where axes should be drawn. One
of the following:
\describe{
\item{\code{"margins"} or \code{FALSE}}{Only draw axes at the outer margins
(default).}
\item{\code{"x"}}{Draw axes at the outer margins and all inner x-axes too.}
\item{\code{"y"}}{Draw axes at the outer margins and all inner y-axes too.}
\item{\code{"all"} or \code{TRUE}}{Draw the axes for every panel.}
}}

\item{remove_labels}{A \code{character(1)} or \code{logical(1)} determining whether
axis text is displayed at inner panels. One of the following:
\describe{
\item{\code{"none"} or \code{FALSE}}{Display axis text at all axes (default).}
\item{\code{"x"}}{Display axis text at outer margins and all inner y-axes.}
\item{\code{"y"}}{Display axis text at outer margins and all inner x-axes.}
\item{\code{"all"} or \code{TRUE}}{Only display axis text at the outer margins.}
}}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:labellers]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:labellers]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{dir}{Direction: either \code{"h"} for horizontal, the default, or \code{"v"},
for vertical.}

\item{strip.position}{By default, the labels are displayed on the top of
the plot. Using \code{strip.position} it is possible to place the labels on
either of the four sides by setting \code{strip.position = c("top",
  "bottom", "left", "right")}}

\item{nest_line}{a theme element, either \code{element_blank()} or inheriting
from \code{\link[ggplot2]{element_line}()}. This element inherits from
the \code{ggh4x.facet.nestline} element in the theme.}

\item{resect}{a \code{unit} vector of length 1, indicating how much the
nesting line should be shortened.}

\item{trim_blank}{A \code{logical(1)}. When \code{TRUE} (default), does not draw rows
and columns containing no panels. When \code{FALSE}, the \code{nrow} and \code{ncol}
arguments are taken literally, even when there are more than needed to
fit all panels.}

\item{strip}{An object created by a call to a strip function, such as
\code{\link[ggh4x]{strip_nested}()}.}

\item{bleed}{Deprecated. Use `strip = strip_nested(bleed = ...)` instead.
See details.}
}
\value{
A \code{FacetNestedWrap} ggproto object that can be added to a plot.
}
\description{
\code{facet_nested_wrap()} wraps a sequence of panels onto a two-dimensional
layout, and nests grouped facets where possible.
}
\details{
This function inherits the capabilities of
  \code{\link[ggh4x]{facet_wrap2}()}.

  This function only merges strips in the same row or column as they appear
  through regular \code{facet_wrap()} layout behaviour.

  Hierarchies are inferred from the order of variables supplied to
  \code{facets}. The first variable is interpreted to be the outermost
  variable, while the last variable is interpreted to be the innermost
  variable. They display order is always such that the outermost
  variable is placed the furthest away from the panels. For more information
  about the nesting of strips, please visit the documentation of
  \code{\link[ggh4x]{strip_nested}()}.
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()

# Similar to `facet_wrap2(..., strip = strip_nested())`.
p + facet_nested_wrap(vars(cyl, drv))

# A nest line inherits from the global theme
p + facet_nested_wrap(vars(cyl, drv),
                      nest_line = element_line(colour = "red")) +
  theme(ggh4x.facet.nestline = element_line(linetype = 3))
}
\seealso{
See \code{\link[ggh4x]{strip_nested}} for nested strips. See
  \code{\link[ggplot2]{facet_wrap}} for descriptions of the original
  arguments. See \code{\link[grid]{unit}} for the construction of a
  \code{unit} vector.

Other facetting functions: 
\code{\link{facet_grid2}()},
\code{\link{facet_manual}()},
\code{\link{facet_nested}()},
\code{\link{facet_wrap2}()}
}
\concept{facetting functions}
