% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_genes.R
\name{theme_genes}
\alias{theme_genes}
\alias{theme_genes_flipped}
\title{A 'ggplot2' theme for drawing gene maps}
\usage{
theme_genes()

theme_genes_flipped()
}
\description{
This theme removes extraneous plot elements for drawing an
'arrows-on-a-string' style gene map in 'ggplot2'.\code{theme_genes_flipped()} is
like \code{theme_genes()}, but for flipped coordinates.
}
\details{
This theme removes strip text (the text that labels facets when you use
\code{ggplot2::facet_wrap()} or \code{ggplot::facet_grid()}). This makes it easier to
draw molecules on different x scales by setting the y aesthetic to the
molecule, then faceting with \code{facet_grid( ~ molecule, scales = "free")}.
}
\examples{

ggplot2::ggplot(example_genes, ggplot2::aes(xmin = start, xmax = end,
                                            y = molecule, fill = gene)) +
geom_gene_arrow() +
ggplot2::facet_wrap(~ molecule, scales = "free") +
theme_genes()

}
\seealso{
\code{\link[=geom_gene_arrow]{geom_gene_arrow()}}
}
