% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_abline}
\alias{gf_abline}
\alias{gf_hline}
\alias{gf_vline}
\alias{gf_coefline}
\title{Reference lines -- horizontal, vertical, and diagonal.}
\usage{
gf_abline(object = NULL, gformula = NULL, data = NULL, geom = type,
  verbose = FALSE, add = inherits(object, c("gg", "ggplot")), ...,
  position = NULL, show.help = NULL)

gf_hline(object = NULL, gformula = NULL, data = NULL, geom = type,
  verbose = FALSE, add = inherits(object, c("gg", "ggplot")), ...,
  position = NULL, show.help = NULL)

gf_vline(object = NULL, gformula = NULL, data = NULL, geom = type,
  verbose = FALSE, add = inherits(object, c("gg", "ggplot")), ...,
  position = NULL, show.help = NULL)

gf_coefline(object = NULL, coef = NULL, model = NULL, ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{Must be \code{NULL}.}

\item{data}{A data frame with the variables to be plotted.}

\item{geom}{A way to specify ggplot geoms that are not aliased to gf functions.}

\item{verbose}{If \code{TRUE} print the ggplot2 command in the console.}

\item{add}{If \code{TRUE} then construct just the layer with no frame.  The result
can be added to an existing frame.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.
Available attributes include
\code{slope}, \code{intercept}}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{coef}{A numeric vector of length at least 2, treated as intercept and slope.
Additional components, if any, are ignored (with a warning).}

\item{model}{An object with a method for \code{coef()} that returns a
numeric vector, the first two elements of which are intercept and slope.
This is equivalent to \code{coef = coef(model)}.}
}
\description{
These fuctions create layers that display lines described i various ways.  Unlike most
of the plotting functions in \code{ggformula}, these functions do not take a formala
as input for describing positional attributes of the plot.
}
\examples{
gf_point(mpg ~ hp, color = ~cyl, size = ~wt, data = mtcars) \%>\%
  gf_abline(color="red", slope = -0.10, intercept = 35)
gf_point(mpg ~ hp, color = ~cyl, size = ~wt, data = mtcars) \%>\%
  gf_abline(color = "red", slope = -0.10, intercept = 33:36) \%>\%
  gf_hline(color = "navy", yintercept = c(20, 25)) \%>\%
  gf_vline(color = "brown", xintercept = c(200, 300))
}
\seealso{
\code{\link{geom_abline}()},
  \code{\link{geom_vline}()},
  \code{\link{geom_hline}()}
}
