% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_bar_text.R, R/geom_fit_text.R
\name{geom_bar_text}
\alias{geom_bar_text}
\alias{geom_fit_text}
\title{A 'ggplot2' geom to fit text inside a box}
\usage{
geom_bar_text(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  padding.x = grid::unit(1, "mm"),
  padding.y = grid::unit(1, "mm"),
  min.size = 8,
  place = NULL,
  grow = FALSE,
  reflow = FALSE,
  hjust = NULL,
  vjust = NULL,
  fullheight = NULL,
  width = NULL,
  height = NULL,
  formatter = NULL,
  contrast = NULL,
  outside = NULL,
  ...
)

geom_fit_text(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  padding.x = grid::unit(1, "mm"),
  padding.y = grid::unit(1, "mm"),
  min.size = 4,
  place = "centre",
  outside = FALSE,
  grow = FALSE,
  reflow = FALSE,
  hjust = NULL,
  vjust = NULL,
  fullheight = NULL,
  width = NULL,
  height = NULL,
  formatter = NULL,
  contrast = FALSE,
  ...
)
}
\arguments{
\item{mapping}{\code{ggplot2::aes()} object as standard in 'ggplot2'. Note
that aesthetics specifying the box must be provided. See Details.}

\item{data, stat, position, na.rm, show.legend, inherit.aes, ...}{Standard geom
arguments as for \code{ggplot2::geom_text()}.}

\item{padding.x, padding.y}{Horizontal and vertical padding around the text,
expressed in \code{grid::unit()} objects. Both default to 1 mm.}

\item{min.size}{Minimum font size, in points. Text that would need to be
shrunk below this size to fit the box will be hidden. Defaults to 4 pt (8 pt
for \code{geom_bar_text()})}

\item{place}{Where inside the box to place the text. Default is 'centre';
other options are 'topleft', 'top', 'topright', 'right', 'bottomright',
'bottom', 'bottomleft', 'left', and 'center'/'middle' which are both
synonyms for 'centre'. For \code{geom_bar_text()}, will be set heuristically if
not specified.}

\item{grow}{If \code{TRUE}, text will be grown as well as shrunk to fill the box.
Defaults to FALSE.}

\item{reflow}{If \code{TRUE}, text will be reflowed (wrapped) to better fit the
box. Defaults to FALSE.}

\item{hjust, vjust}{Horizontal and vertical justification of the text. By
default, these are automatically set to appropriate values based on \code{place}.}

\item{fullheight}{If \code{TRUE}, descenders will be counted when resizing and
placing text; if \code{FALSE}, only the x-height and ascenders will be counted.
The main use for this option is for aligning text at the baseline (\code{FALSE})
or preventing descenders from spilling outside the box (\code{TRUE}). By default
this is set automatically depending on \code{place} and \code{grow}.}

\item{width, height}{When using \code{x} and/or \code{y} aesthetics, these set the
width and/or height of the box. These should be either \code{grid::unit()}
objects or numeric values on the \code{x} and \code{y} scales.}

\item{formatter}{A function that will be applied to the text before it is
drawn. This is useful when using \code{geom_fit_text()} in context involving
interpolated variables, such as with the 'gganimate' package. \code{formatter}
will be applied serially to each element in the \code{label} column, so it does
not need to be a vectorised function.}

\item{contrast}{If \code{TRUE} and in combination with a \code{fill} aesthetic, the
colour of the text will be inverted for better contrast against dark
background fills. \code{FALSE} by default for \code{geom_fit_text()}, set
heuristically for \code{geom_bar_text()}.}

\item{outside}{If \code{TRUE}, text placed in one of 'top', 'right', 'bottom' or
'left' that would need to be shrunk smaller than \code{min.size} to fit the box
will be drawn outside the box if possible. This is mostly useful for drawing
text inside bar/column geoms. Defaults to TRUE for \code{position = "identity"}
when using \code{geom_bar_text()}, otherwise FALSE.}
}
\description{
\code{geom_fit_text()} shrinks, grows and wraps text to fit inside a defined
box.
\code{geom_bar_text()} is a convenience wrapper around \code{geom_fit_text()} for
labelling bar plots generated with \code{geom_col()} and \code{geom_bar()}.
}
\details{
Except where noted, \code{geom_fit_text()} behaves more or less like
\code{ggplot2::geom_text()}.

There are three ways to define the box in which you want the text to be
drawn. The extents of the box on the x and y axes are independent, so any
combination of these methods can be used:
\enumerate{
\item If the \code{x} and/or \code{y} aesthetics are used to set the location of the box,
the width or height will be set automatically based on the number of
discrete values in \code{x} and/and \code{y}.
\item Alternatively, if \code{x} and/or \code{y} aesthetics are used, the width and/or
height of the box can be overridden with a 'width' and/or 'height' argument.
These should be \code{grid::unit()} objects; if not, they will be assumed to use
the native axis scale.
\item The boundaries of the box can be set using the aesthetics 'xmin' and
'xmax', and/or 'ymin' and 'ymax'.
}

If the text is too big for the box, it will be shrunk to fit the box. With
\code{grow = TRUE}, the text will be made to fill the box completely whether that
requires shrinking or growing.

\code{reflow = TRUE} will cause the text to be reflowed (wrapped) to better fit
in the box. If the text cannot be made to fit by reflowing alone, it will be
reflowed then shrunk to fit the box.  Existing line breaks in the text will
be respected when reflowing.

\code{geom_fit_text()} includes experimental support for drawing text in polar
coordinates (by adding \code{coord_polar()} to the plot), however not all
features are available when doing so.
}
\section{Aesthetics}{

\itemize{
\item label (required)
\item (xmin AND xmax) OR x (required)
\item (ymin AND ymax) OR y (required)
\item alpha
\item angle
\item colour
\item family
\item fontface
\item lineheight
\item size
}
}

\examples{

ggplot2::ggplot(ggplot2::presidential, ggplot2::aes(ymin = start, ymax = end,
    label = name, x = party)) +
  geom_fit_text(grow = TRUE)

}
