% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{easy_change_legend}
\alias{easy_change_legend}
\alias{easy_move_legend}
\alias{easy_legend_at}
\alias{easy_rotate_legend}
\alias{easy_adjust_legend}
\title{Easily modify legends}
\usage{
easy_change_legend(what = c("position", "direction", "justification"),
  to, teach = FALSE)

easy_move_legend(to = c("right", "none", "left", "bottom", "top"),
  teach = FALSE)

easy_legend_at(to = c("right", "none", "left", "bottom", "top"),
  teach = FALSE)

easy_rotate_legend(to = c("vertical", "horizontal"), teach = FALSE)

easy_adjust_legend(to = c("left", "right", "center"), teach = FALSE)
}
\arguments{
\item{what}{legend component to modify
(\code{"position"}, \code{"direction"}, or \code{"justification"})}

\item{to}{to what to set the legend component should be changed}

\item{teach}{print longer equivalent \code{\link[ggplot2]{ggplot2}}
expression?}
}
\value{
a \code{\link[ggplot2]{theme}} object
}
\description{
Change legend position, direction, or justification.
}
\details{
Due to limitations of \code{ggplot2} this will apply to all legends at once
}
\examples{

library(ggplot2)

# Move legends to bottom
ggplot(mtcars, aes(wt, mpg, colour = cyl, size = hp)) +
  geom_point() + easy_move_legend("bottom")

# Make legends horizontal
ggplot(mtcars, aes(wt, mpg, colour = cyl, size = hp)) +
  geom_point() + easy_rotate_legend("horizontal")

# Justify legends to the bottom and justify to the right
ggplot(mtcars, aes(wt, mpg, colour = cyl, size = hp)) +
  geom_point() +
  easy_move_legend("bottom") +
  easy_adjust_legend("right")
}
\author{
Jonathan Carroll
}
