% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetGamma}
\alias{GetGamma}
\title{Generate a Gamma Vector}
\usage{
GetGamma(npar, gammamult, hyper = FALSE)
}
\arguments{
\item{npar}{number of parameters.}

\item{gammamult}{a tuning parameter stands for for gamma mutation. Default
value is 2.38.}

\item{hyper}{a boolean switch, indicating to calculate hyper gamma}
}
\value{
a vector
}
\description{
This is part of DE-MCMC algorithm. This function generates a gamma vector
for element-wise computation in Armadillo C++. This function is based on
p242 ter Braak (2006) who cited Roberts and Rosenthal (2001)
}
\examples{
pVec <- c(A = 1.51, b = 2.7, muv1 = 3.32, muv2 = 2.24, t_ND = 0.08,
          muw1 = 1.51, muw2 = 3.69, t_delay = 0.31, sv = 1, swt = 0.5)
gamma <- GetGamma(length(pVec), 2.38)
}
