% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{mejr_geom_defaults}
\alias{mejr_geom_defaults}
\title{Setup defaults for specific geoms}
\usage{
mejr_geom_defaults(base_size = 11, black = 51, gray = 214, lty = 3,
  lwd = base_size/20, cex = base_size/9, stroke = base_size * 0.05,
  alpha = 0.5, pch = 21, txt = base_size/4, reset = FALSE)
}
\arguments{
\item{base_size}{base font size}

\item{black}{Values from 0 to 255, indicating the darkest line and
text colors (255).}

\item{gray}{gray color value (0-255)}

\item{lty}{linetype}

\item{lwd}{linewidth}

\item{cex}{point size}

\item{stroke}{stroke width}

\item{alpha}{alpha}

\item{pch}{point shape}

\item{txt}{text size}

\item{reset}{reset all back to default}
}
\description{
Setup defaults for specific geoms
}
\examples{
# This will change the point size and shape for
#  all geoms in which GeomPoint inherits from.
mejr_geom_defaults(cex = 1.1, pch = 19)

# Reset defaults back to their original state.
mejr_geom_defaults(reset=TRUE)
}
