% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_lineribbon.R
\name{stat_lineribbon}
\alias{stat_lineribbon}
\alias{stat_dist_lineribbon}
\title{Line + multiple probability ribbon plots (ggplot stat)}
\usage{
stat_lineribbon(
  mapping = NULL,
  data = NULL,
  geom = "lineribbon",
  position = "identity",
  ...,
  interval_function = NULL,
  interval_args = list(),
  point_interval = median_qi,
  .width = c(0.5, 0.8, 0.95),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  .prob,
  fun.data,
  fun.args
)

stat_dist_lineribbon(
  mapping = NULL,
  data = NULL,
  geom = "lineribbon",
  position = "identity",
  ...,
  n = 501,
  .width = c(0.5, 0.8, 0.95),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between
\code{geom_lineribbon} and \code{stat_lineribbon}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. They may also be arguments to the paired geom
(e.g., \code{\link[=geom_pointinterval]{geom_pointinterval()}})}

\item{interval_function}{Custom function for generating intervals (for most common use cases the \code{point_interval}
argument will be easier to use). This function takes a data frame of aesthetics and a \code{.width} parameter (a vector
of interval widths), and returns a data frame with
columns \code{.width} (from the \code{.width} vector), \code{.value} (point summary) and \code{.lower} and \code{.upper}
(endpoints of the intervals, given the \code{.width}). Output will be converted to the appropriate \code{x}- or
\code{y}-based aesthetics depending on the value of \code{orientation}. If \code{interval_function} is \code{NULL},
\code{point_interval} is used instead.}

\item{interval_args}{Additional arguments passed to \code{interval_function} or \code{point_interval}.}

\item{point_interval}{A function from the \code{\link[=point_interval]{point_interval()}} family (e.g., \code{median_qi},
\code{mean_qi}, etc). This function should take in a vector of value, and should obey the
\code{.width} and \code{.simple_names} parameters of \code{\link[=point_interval]{point_interval()}} functions, such that when given
a vector with \code{.simple_names = TRUE} should return a data frame with variables \code{.value}, \code{.lower},
\code{.upper}, and \code{.width}. Output will be converted to the appropriate \code{x}- or \code{y}-based aesthetics
depending on the value of \code{orientation}. See the \code{\link[=point_interval]{point_interval()}} family of functions for
more information.}

\item{.width}{The \code{.width} argument passed to \code{interval_function} or \code{point_interval}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? \code{NA}, the default, includes if any aesthetics
are mapped. \code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{.prob}{Deprecated. Use \code{.width} instead.}

\item{fun.data}{Deprecated. Use \code{point_interval} or \code{interval_function} instead.}

\item{fun.args}{Deprecated. Use \code{interval_args} instead.}

\item{n}{Number of points at which to evaluate \code{slab_function}}
}
\value{
A \link[ggplot2:Stat]{ggplot2::Stat} representing a combined line+uncertainty ribbon geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
A combination of \code{\link[=stat_slabinterval]{stat_slabinterval()}} and \code{\link[=geom_lineribbon]{geom_lineribbon()}} with sensible defaults.
While \code{geom_lineribbon} is intended for use on data frames that have already been summarized using
a \code{\link[=point_interval]{point_interval()}} function, \code{stat_lineribbon} is intended for use directly on data
frames of draws, and will perform the summarization using a \code{\link[=point_interval]{point_interval()}} function;
\code{stat_dist_lineribbon} is intended for use on analytical distributions through the \code{dist},
\code{arg1}, ... \code{arg9}, and \code{args} aesthetics.
}
\examples{

library(dplyr)
library(ggplot2)

tibble(x = 1:10) \%>\%
  group_by_all() \%>\%
  do(tibble(y = rnorm(100, .$x))) \%>\%
  ggplot(aes(x = x, y = y)) +
  stat_lineribbon() +
  scale_fill_brewer()

tibble(
  x = 1:10,
  sd = seq(1, 3, length.out = 10)
) \%>\%
  ggplot(aes(x = x, dist = "norm", arg1 = x, arg2 = sd)) +
  stat_dist_lineribbon() +
  scale_fill_brewer()

}
\seealso{
See \code{\link[=geom_lineribbon]{geom_lineribbon()}} for the geom version, intended for use on points and intervals that have
already been summarized using a \code{\link[=point_interval]{point_interval()}} function. See \code{\link[=stat_pointinterval]{stat_pointinterval()}}
for a similar stat intended for point summaries and intervals.
}
