% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-stratum.r
\name{stat_stratum}
\alias{stat_stratum}
\title{Stratum positions}
\usage{
stat_stratum(mapping = NULL, data = NULL, geom = "stratum",
  position = "identity", decreasing = ggalluvial_opt("decreasing"),
  reverse = ggalluvial_opt("reverse"),
  absolute = ggalluvial_opt("absolute"), discern = FALSE,
  negate.strata = NULL, infer.label = FALSE, label.strata = NULL,
  min.y = NULL, max.y = NULL, min.height = NULL, max.height = NULL,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data;
override the default.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{decreasing}{Logical; whether to arrange the strata at each axis
in the order of the variable values (\code{NA}, the default),
in ascending order of totals (largest on top, \code{FALSE}), or
in descending order of totals (largest on bottom, \code{TRUE}).}

\item{reverse}{Logical; if \code{decreasing} is \code{NA},
whether to arrange the strata at each axis
in the reverse order of the variable values,
so that they match the order of the values in the legend.
Ignored if \code{decreasing} is not \code{NA}.
Defaults to \code{TRUE}.}

\item{absolute}{Logical; if some cases or strata are negative,
whether to arrange them (respecting \code{decreasing} and \code{reverse})
using negative or absolute values of \code{y}.}

\item{discern}{Passed to \code{\link[=to_lodes_form]{to_lodes_form()}} if \code{data} is in
alluvia format.}

\item{negate.strata}{A vector of values of the \code{stratum} aesthetic to be
treated as negative (will ignore missing values with a warning).}

\item{infer.label}{Logical; whether to assign the \code{stratum} or \code{alluvium}
variable to the \code{label} aesthetic. Defaults to \code{FALSE}, and requires that
no \code{label} aesthetic is assigned. This parameter is intended only for uses
in which the data are in alluva form and are therefore converted to lode
form before the statistical transformation.}

\item{label.strata}{Deprecated; alias for \code{infer.label}.}

\item{min.y, max.y}{Numeric; bounds on the heights of the strata to be
rendered. Use these bounds to exclude strata outside a certain range, for
example when labeling strata using \code{\link[ggplot2:geom_text]{ggplot2::geom_text()}}.}

\item{min.height, max.height}{Deprecated aliases for \code{min.y} and \code{max.y}.}

\item{na.rm}{Logical:
if \code{FALSE}, the default, \code{NA} lodes are not included;
if \code{TRUE}, \code{NA} lodes constitute a separate category,
plotted in grey (regardless of the color scheme).}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}
}
\description{
Given a dataset with alluvial structure, \code{stat_stratum} calculates the
centroids (\code{x} and \code{y}) and heights (\code{ymin} and \code{ymax}) of the strata at each
axis.
}
\section{Aesthetics}{

\code{stat_alluvium}, \code{stat_flow}, and \code{stat_stratum} require one
of two sets of aesthetics:
\itemize{
\item \strong{\code{x}} and at least one of \strong{\code{alluvium}} and \strong{\code{stratum}}
\item any number of \strong{\code{axis[0-9]*}} (\code{axis1}, \code{axis2}, etc.)
}

Use \code{x}, \code{alluvium}, and/or \code{stratum} for data in lodes format
and \code{axis[0-9]*} for data in alluvia format (see \code{\link{alluvial-data}}).
Arguments to parameters inconsistent with the format will be ignored.
Additionally, each \code{stat_*()} accepts the following optional
aesthetics:
\itemize{
\item \code{y}
\item \code{group}
\item \code{label}
}

\code{y} controls the heights of the alluvia
and may be aggregated across equivalent observations.
\code{group} is used internally; arguments are ignored.
\code{label} is used to label the strata or lodes and must take a unique value
across the observations within each stratum or lode.
Often the same variable will be passed to \code{label} as to the corresponding
alluvial aesthetic (\code{stratum} or \code{alluvium}).

These and any other aesthetics are aggregated as follows:
Numeric aesthetics, including \code{y}, are summed.
Character and factor aesthetics, including \code{label},
are assigned to strata or lodes provided they take unique values across the
observations within each (and are otherwise assigned \code{NA}).
}

\section{Package options}{

\code{stat_stratum}, \code{stat_alluvium}, and \code{stat_flow} order strata and lodes
according to the values of several parameters, which must be held fixed
across every layer in an alluvial plot. These package-specific options set
global values for these parameters that will be defaulted to when not
manually set:
\itemize{
\item \code{ggalluvial.decreasing} (each \code{stat_*}): defaults to \code{NA}.
\item \code{ggalluvial.reverse} (each \code{stat_*}): defaults to \code{TRUE}.
\item \code{ggalluvial.absolute} (each \code{stat_*}): defaults to \code{TRUE}.
\item \code{ggalluvial.cement.alluvia} (\code{stat_alluvium}): defaults to \code{FALSE}.
\item \code{ggalluvial.lode.guidance} (\code{stat_alluvium}): defaults to \code{"zigzag"}.
\item \code{ggalluvial.lode.ordering} (\code{stat_alluvium}): defaults to \code{NULL}.
\item \code{ggalluvial.aes.bind} (\code{stat_alluvium} and \code{stat_flow}): defaults to
\code{"none"}.
}

See \code{\link[base:options]{base::options()}} for how to use options.
}

\section{Defunct parameters}{

The previously defunct parameters \code{weight} and \code{aggregate.wts} have been
discontinued. Use \code{y} and \code{cement.alluvia} instead.
}

\examples{
# only `stratum` assignment is necessary to generate strata
data(vaccinations)
ggplot(vaccinations,
       aes(y = freq,
           x = survey, stratum = response,
           fill = response)) +
  stat_stratum(width = .5)

# lode data, positioning with y labels
ggplot(vaccinations,
       aes(y = freq,
           x = survey, stratum = response, alluvium = subject,
           label = freq)) +
  stat_stratum(geom = "errorbar") +
  geom_text(stat = "stratum")
# alluvium data, positioning with stratum labels
ggplot(as.data.frame(Titanic),
       aes(y = Freq,
           axis1 = Class, axis2 = Sex, axis3 = Age, axis4 = Survived)) +
  geom_text(stat = "stratum", infer.label = TRUE) +
  stat_stratum(geom = "errorbar") +
  scale_x_discrete(limits = c("Class", "Sex", "Age", "Survived"))

# omit labels for strata outside a y range
ggplot(vaccinations,
       aes(y = freq,
           x = survey, stratum = response,
           fill = response, label = response)) +
  stat_stratum(width = .5) +
  geom_text(stat = "stratum", min.y = 100)

# use negative y values to encode rejection versus acceptance
admissions <- as.data.frame(UCBAdmissions)
admissions <- transform(admissions, Count = Freq * (-1) ^ (Admit == "Rejected"))
ggplot(admissions,
       aes(y = Count, axis1 = Dept, axis2 = Gender)) +
  geom_alluvium(aes(fill = Dept), width = 1/12) +
  geom_stratum(width = 1/12, fill = "black", color = "grey") +
  geom_label(stat = "stratum", infer.label = TRUE, min.y = 200) +
  scale_x_discrete(limits = c("Department", "Gender"), expand = c(.05, .05))
}
\seealso{
\code{\link[ggplot2:layer]{ggplot2::layer()}} for additional arguments and
\code{\link[=geom_stratum]{geom_stratum()}} for the corresponding geom.

Other alluvial stat layers: \code{\link{stat_alluvium}},
  \code{\link{stat_flow}}
}
\concept{alluvial stat layers}
