% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-panel.R
\name{align_panel}
\alias{align_panel}
\alias{ggpanel}
\title{Create ggplot object with layout panel data}
\usage{
align_panel(
  mapping = aes(),
  size = NULL,
  free_guides = waiver(),
  free_spaces = waiver(),
  plot_data = waiver(),
  theme = waiver(),
  free_labs = waiver(),
  limits = TRUE,
  facet = TRUE,
  set_context = TRUE,
  order = NULL,
  name = NULL
)

ggpanel(
  mapping = aes(),
  size = NULL,
  free_guides = waiver(),
  free_spaces = waiver(),
  plot_data = waiver(),
  theme = waiver(),
  free_labs = waiver(),
  limits = TRUE,
  facet = TRUE,
  set_context = TRUE,
  order = NULL,
  name = NULL
)
}
\arguments{
\item{mapping}{Additional default list of aesthetic mappings to use for plot.}

\item{size}{Plot size, can be an \link[grid:unit]{unit} object.}

\item{free_guides}{Override the \code{guides} argument specified in the layout for
a plot. Options include:
\itemize{
\item \code{\link[ggplot2:waiver]{waiver()}}: inherits behavior from the layout.
\item \code{NULL}: no guide legends will be collected for the plot.
\item A string containing one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"} indicates which side of guide legends should be collected for the plot..
}}

\item{free_spaces}{A string with one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"}
indicating which border spaces should be removed. Defaults to
\code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If no
parent, the default is \code{NULL}, meaning no spaces are removed.}

\item{plot_data}{A function to transform plot data before rendering. Defaults
to \code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If
no parent layout, the default is \code{NULL}, meaning the data won't be modified.

Used to modify the data after layout has been created, which should be a data
frame, but before the data is handled of to the ggplot2 for rendering. Use
this hook if the you needs change the default data for all \code{geoms}.}

\item{theme}{Default plot theme: One of:
\itemize{
\item \code{\link[ggplot2:waiver]{waiver()}}: will inherit from the parent layout.
\item \code{NULL}: Use the \link[=theme_ggalign]{default theme}.
\item \code{\link[ggplot2:theme]{theme()}}: will be added with the parent layout theme.
}

\verb{Note:} The axis title and labels parallel to the layout axis will always be
removed by default. For vertical stack layouts, this refers to the \code{x-axis},
and for horizontal stack layouts, this refers to the \code{y-axis}. If you want to
display the axis title or labels, you should manually add
\link[ggplot2:theme]{theme()} elements for the parallel axis title or labels.}

\item{free_labs}{A string with one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"} indicating
which axis titles should be free from alignment. Defaults to
\code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If no
parent layout, no axis titles will be aligned. If \code{NULL}, all axis titles
will be aligned.}

\item{limits}{A boolean value indicates whether to set the layout limtis for
the plot.}

\item{facet}{A boolean value indicates whether to set the layout facet for
the plot. If this is \code{FALSE}, \code{limits} will always be \code{FALSE} too.}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{order}{An single integer for the plot area order.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}
}
\value{
A \code{AlignPanel} object.
}
\description{
This is similar with \code{ggalign()} function, but it will always use the layout
panel data. \code{ggpanel} is just an alias of \code{align_panel}.
}
\section{ggplot2 specification}{

\code{align_panel} initializes a ggplot \code{data} and \code{mapping}.

\code{align_panel()} always applies a default mapping for the axis of the data
index in the layout. This mapping is \code{aes(y = .data$.y)} for horizontal stack
layout (including left and right heatmap annotation) and \code{aes(x = .data$.x)}
for vertical stack layout (including top and bottom heatmap annotation).

The data in the underlying \code{ggplot} object contains following columns:
\itemize{
\item \code{.panel}: the panel for current layout axis. It means \code{x-axis} for
vertical stack layout, \code{y-axis} for horizontal stack layout.
\item \code{.index}: the index of the original layout data.
\item \code{.x} or \code{.y}: the \code{x} or \code{y} coordinates
}
}

\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("top") +
    ggalign() +
    geom_point(aes(y = value))
}
