% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_stat_mR.r
\name{stat_mR}
\alias{stat_mR}
\title{Generate mR chart in ggplot}
\usage{
stat_mR(mapping = NULL, data = NULL, geom = "point",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  na.rm = FALSE, color.mr_point = "black", color.mr_line = "black",
  color.qc_limits = "red", color.qc_center = "blue", ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{color.mr_point}{color, to be used for the mR points.}

\item{color.mr_line}{color, to be used for line connecting points.}

\item{color.qc_limits}{color, used to colorize the plot's upper and lower mR control limits.}

\item{color.qc_center}{color, used to colorize the plot's center line.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
data need to produce the mR plot in ggplot.
}
\description{
ggplot stat used to create a mR chart in ggplot
}
\examples{
#########################
#  Example 1: mR Chart  #
#########################

# Load Libraries ----------------------------------------------------------
 require(ggQC)
 require(ggplot2)

# Setup Data --------------------------------------------------------------
 set.seed(5555)
 Process1 <- data.frame(processID = as.factor(rep(1,100)),
                        metric_value = rnorm(100,0,1),
                        subgroup_sample=rep(1:20, each=5),
                        Process_run_id = 1:100)
 set.seed(5556)
 Process2 <- data.frame(processID = as.factor(rep(2,100)),
                        metric_value = rnorm(100,5, 1),
                        subgroup_sample=rep(1:10, each=10),
                        Process_run_id = 101:200)

 Both_Processes <- rbind(Process1, Process2)

# One Plot Both Processes -------------------------------------------------
 ggplot(Both_Processes, aes(x=Process_run_id, y = metric_value)) +
   stat_mR() + ylab("Moving Range")

# Facet Plot - Both Processes ---------------------------------------------
 ggplot(Both_Processes, aes(x=Process_run_id, y = metric_value)) +
   stat_mR() + ylab("Moving Range") +
   facet_grid(.~processID, scales = "free_x")
}
