% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_prediction.R
\name{fit_tte_data}
\alias{fit_tte_data}
\title{Fit Weibull, Log-Normal or Exponential survival curves to patient-level time-to-event data}
\usage{
fit_tte_data(
  data,
  Time = "Time",
  Event = "Event",
  censoringOne = FALSE,
  type = c("automatic", "Weibull", "Lognormal", "Exponential"),
  init = NULL
)
}
\arguments{
\item{data}{The dataframe object containing the patient-level survival data}

\item{Time}{The column name for the times. Default is "Time"}

\item{Event}{The column name for the events column (i.e. the binary variable denoting events vs censorings). Default is "Event"}

\item{censoringOne}{Specify whether censoring is denoted in the Event column by a one (TRUE) or zero (FALSE). Default=FALSE (censorings denoted by 0, events by 1)}

\item{type}{Type of event curve to fit. Default is "Automatic", fitting both Weibull and Log-normal curves.
Alternatively accepts "Weibull" or "Lognormal" to force the type.}

\item{init}{Vector of starting values for parameter values; useful if survreg experiences convergence issues. Default=NULL (no values specified)}
}
\value{
Returns a 3-item list providing information needed to define a Curve object:
\itemize{
 \item{"Item 1"}{The type of Curve object fitted.}
 \item{"Item 2"}{A list of fitted parameters for the curve type.}
 \item{"Item 3"}{A vector containing the covariance-matrix parameters for the curve type.}
 \item{"Item 4"}{A data frame containing the goodness of fit metrics for each curve type.}
}
}
\description{
This is a function to fit Weibull and log-normal curves to patient-level Survival data using maximum likelihood estimation.\cr
By default it fits both, then picks the best fit based on the log-likelihood (and implicitly the AIC).\cr
Alternatively, just one shape may be fitted, by changing the 'type' argument to either "Weibull" or "Lognormal".
This function is primarily used by event_prediction_data function, but also useful for general Survival function curve fitting.\cr
One useful aspect of this is for fitting the 'inverse KM', where drop-outs are events, while events and 'time-outs' are censored.
   This allows for finding a suitable parameterisation for the censoring curve.\cr
Where patient-level data is available, this function will typically perform substantially better than fit_KM, with lower variability of point estimates (and more accurate quantification of it).
}
\examples{
recruit <- PieceR(matrix(c(rep(1,12),10,15,25,30,45,60,55,50,65,60,55,30),ncol=2),1)
example_data <- simulate_trials(active_ecurve=Weibull(50,0.8),control_ecurve=Weibull(50,0.8),
rcurve=recruit, assess=10,iterations=1,seed=12345,detailed_output=TRUE)

fit_tte_data(data=example_data,Time="Time",Event="Censored",censoringOne=TRUE,type="automatic")
}
\author{
James Bell
}
